/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.ebg.aqap.banks.hrb.dc.util.Base64Util;
import kd.ebg.aqap.banks.hrb.dc.util.StatusEnum;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceImpl.class);
    private static final String COMMON_SUCCESS = "0000000";

    public String pack(BankBalanceRequest bankBalanceRequest) {
        if (bankBalanceRequest == null) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u7684\u8d26\u53f7\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_0", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
        }
        Element BankData = new Element("BankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE001");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)StringUtils.toString((Object)new Date().getTime()));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)DateUtil.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        BankAcnt bankAcnt = bankBalanceRequest.getAcnt();
        if (bankAcnt != null && bankAcnt.getAccNo() != null) {
            JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)bankAcnt.getAccNo());
            String reqMsg = JDomUtils.root2String((Element)BankData, (String)RequestContextUtils.getCharset());
            String cusNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
            reqMsg = StatusEnum.BALANCE_INFO.getCode() + "|" + cusNo + "|1106|#" + reqMsg;
            this.logger.info("\u4f59\u989d\u67e5\u8be2\u62a5\u6587\u539f\u6587:{}", (Object)reqMsg);
            return Base64Util.compressDataAndEncode(reqMsg);
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u4e1a\u52a1\u7f3a\u5c11\u8d26\u53f7\u4fe1\u606f\u3002", (String)"TodayBalanceImpl_1", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        String[] results = s.split("\\|");
        String resultCode = results[0];
        if (!StringUtils.equalsIgnoreCase((String)resultCode, (String)COMMON_SUCCESS)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)resultCode, (String)results[1]));
        }
        String resultXml = s.substring(s.indexOf("#") + 1);
        Element bankData = JDomUtils.string2Root((String)resultXml, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElementNotNull((Element)bankData, (String)"opRep");
        Element opResult = JDomUtils.getChildElementNotNull((Element)opRep, (String)"opResult");
        Element list = JDomUtils.getChildElementNotNull((Element)opResult, (String)"list");
        List children = list.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u4e3a\u7a7a\u3002", (String)"TodayBalanceImpl_3", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]));
        }
        Element element = (Element)children.get(0);
        String accountNo = JDomUtils.getChildTextNotNull((Element)element, (String)"accountNo");
        String balance = JDomUtils.getChildText((Element)element, (String)"balance");
        String balanceAvailable = JDomUtils.getChildText((Element)element, (String)"balanceAvailable");
        BalanceInfo info = new BalanceInfo();
        this.setBankAcnt(info, bankBalanceRequest.getBankAcntList(), accountNo);
        info.setBalanceDateTime(LocalDateTime.now());
        this.setCurrentBalance(info, balance);
        this.setAvailableBalance(info, balanceAvailable);
        info.setBankCurrency(bankBalanceRequest.getBankCurrency());
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{info}));
    }

    public void configFactory(ConnectionFactory factory) {
        super.configFactory(factory);
        factory.setUri("/corplink/httpAccess");
        factory.setHttpHeader("Content-Type", "text/xml;charset=" + RequestContextUtils.getCharset());
    }

    public String getDeveloper() {
        return "xs";
    }

    public String getBizCode() {
        return "CBE001";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u5f53\u65e5\u4f59\u989d", (String)"TodayBalanceImpl_7", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]);
    }
}

