/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.payment.outer;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hrb.dc.util.Base64Util;
import kd.ebg.aqap.banks.hrb.dc.util.SvsSignInfoSec;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayPacker {
    private static final Logger logger = LoggerFactory.getLogger(PayPacker.class);

    public String packPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String cusNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        String ip = RequestContextUtils.getBankParameterValue((String)"ip");
        String port = RequestContextUtils.getBankParameterValue((String)"signPort");
        Element BankData = new Element("BankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE004");
        JDomUtils.addChild((Element)opReq, (String)"cstNo", (String)cusNo);
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)paymentInfos.get(0).getBankBatchSeqID());
        String reqTime = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)reqTime);
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        String signData = "";
        String sign = "";
        String reqMsg = "";
        String accNo = paymentInfos.get(0).getAccNo();
        String accName = paymentInfos.get(0).getAccName();
        String incomeAccNo = paymentInfos.get(0).getIncomeAccNo();
        String incomeAccName = paymentInfos.get(0).getIncomeAccName();
        String amount = paymentInfos.get(0).getAmount().toString();
        String explanation = paymentInfos.get(0).getExplanation();
        JDomUtils.addChild((Element)ReqParam, (String)"payAccount", (String)accNo);
        JDomUtils.addChild((Element)ReqParam, (String)"payAccountName", (String)accName);
        JDomUtils.addChild((Element)ReqParam, (String)"recAccount", (String)incomeAccNo);
        JDomUtils.addChild((Element)ReqParam, (String)"recAccountName", (String)incomeAccName);
        JDomUtils.addChild((Element)ReqParam, (String)"payAmount", (String)amount);
        JDomUtils.addChild((Element)ReqParam, (String)"unionBankNo", (String)paymentInfos.get(0).getIncomeCnaps());
        JDomUtils.addChild((Element)ReqParam, (String)"rmtType", (String)(paymentInfos.get(0).is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)ReqParam, (String)"payUse", (String)explanation);
        logger.info("\u4ed8\u6b3e\u5e01\u79cd\uff1a" + paymentInfos.get(0).getCurrency());
        if (paymentInfos.get(0).getCurrency() != null && !paymentInfos.get(0).getCurrency().equals("")) {
            JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)paymentInfos.get(0).getCurrency());
        } else {
            JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)"01");
        }
        signData = String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7801#CBE004|\u8bf7\u6c42\u65f6\u95f4#%1$s|\u4ed8\u6b3e\u8d26\u53f7#%2$s|\u4ed8\u6b3e\u6237\u540d#%3$s|\u6536\u6b3e\u8d26\u53f7#%4$s|\u6536\u6b3e\u6237\u540d#%5$s|\u4ea4\u6613\u91d1\u989d#%6%s|\u8054\u884c\u53f7#%7$s", (String)"PayPacker_8", (String)"ebg-aqap-banks-hrb-dc", (Object[])new Object[0]), reqTime, accNo, accName, incomeAccNo, incomeAccName, amount, paymentInfos.get(0).getIncomeCnaps());
        sign = SvsSignInfoSec.signData(signData, ip, port);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)sign);
        JDomUtils.addChild((Element)ReqParam, (String)"signDataField", (String)signData);
        reqMsg = JDomUtils.root2String((Element)BankData, (String)RequestContextUtils.getCharset());
        reqMsg = "CBE004|" + cusNo + "|1106|#" + reqMsg;
        logger.info("\u7b7e\u540d\u6570\u636e\uff1a{},\u7b7e\u540d\u6570\u636e\u5bc6\u6587\uff1a{},\u8de8\u884c\u4ed8\u6b3e\u5c01\u88c5\u62a5\u6587\u5982\u4e0b:{}", new Object[]{signData, sign, reqMsg});
        return Base64Util.compressDataAndEncode(reqMsg);
    }
}

