/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hrb.dc.service.payment.outer;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.ebg.aqap.banks.hrb.dc.util.Base64Util;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPayPacker {
    private static final Logger logger = LoggerFactory.getLogger(QueryPayPacker.class);

    public String packQueryPay(List<PaymentInfo> paymentInfos) throws EBServiceException {
        String cusNo = RequestContextUtils.getBankParameterValue((String)"CUST_NO");
        String bankBatchSeqID = paymentInfos.get(0).getBankBatchSeqID();
        Element BankData = new Element("BankData");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)BankData, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"bsnCode", (String)"CBE010");
        JDomUtils.addChild((Element)opReq, (String)"serialNo", (String)String.valueOf(Sequence.gen16NumSequence()));
        JDomUtils.addChild((Element)opReq, (String)"reqTime", (String)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
        Element ReqParam = new Element("ReqParam");
        JDomUtils.addChild((Element)opReq, (Element)ReqParam);
        JDomUtils.addChild((Element)ReqParam, (String)"orderFlowNo", (String)bankBatchSeqID);
        JDomUtils.addChild((Element)ReqParam, (String)"queryBsnCode", (String)"CBE004");
        JDomUtils.addChild((Element)ReqParam, (String)"reqReserved1", (String)"");
        JDomUtils.addChild((Element)ReqParam, (String)"reqReserved2", (String)"");
        String reqMsg = JDomUtils.root2String((Element)BankData, (String)RequestContextUtils.getCharset());
        reqMsg = "CBE010|" + cusNo + "|1106|#" + reqMsg;
        logger.info("\u8de8\u884c\u4ed8\u6b3e\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u62a5\u6587\uff1a{}", (Object)reqMsg);
        return Base64Util.compressDataAndEncode(reqMsg);
    }
}

