/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.card;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.area.ICBCArea;
import kd.ebg.aqap.banks.icbc.cmp.area.ICBCAreaStore;
import kd.ebg.aqap.banks.icbc.cmp.card.CardWithHandle;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class CardWithAreaCode
extends CardWithHandle {
    private int startIndex;
    private static final int LEN = 4;

    public CardWithAreaCode(String accNoPrefix, int typeNo, int startIndex) {
        super(accNoPrefix, typeNo);
        this.startIndex = startIndex;
    }

    @Override
    public ICBCArea getICBCArea(String accNo) {
        String areaCode = "";
        try {
            areaCode = accNo.substring(this.startIndex - 1, this.startIndex + 4 - 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u53f7\u4e0d\u7b26\u5408\u5361\u67c4\u89c4\u5219\u3002", (String)"CardWithAreaCode_0", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
        }
        return ICBCAreaStore.getInstance().getAreaByAreaCode(areaCode, accNo);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(',');
        sb.append(this.getMl1());
        sb.append(',');
        sb.append(this.getMl2());
        sb.append('=');
        sb.append(this.startIndex);
        sb.append("\u3011");
        return sb.toString();
    }

    private String getMl1() {
        return ResManager.loadKDString((String)"\u7b97\u6cd5={\u622a\u53d6\u53d1\u5361\u673a\u6784\u5730\u533a\u53f7,\u6839\u636e\u5730\u533a\u53f7\u67e5\u627e\u5730\u533a}", (String)"CardWithAreaCode_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }

    private String getMl2() {
        return ResManager.loadKDString((String)"\u622a\u53d6\u8d77\u59cb\u4f4d\u7f6e", (String)"CardWithAreaCode_2", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]);
    }
}

