/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.reconciliation.KDProcessorFactory;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.SSLConnection;
import kd.ebg.egf.common.framework.communication.util.IOUtils;
import kd.ebg.egf.common.framework.conf.IParameter;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.string.StrUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class ICBC_CMP_Packer {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(ICBC_CMP_Packer.class);
    private static String testSign = "<html>\n<head>\n<title>signResult</title>\n<result>0</result>\n</head>\n<body>\n<sign>MIIN1wYJKoZIhvcNAQcCoIINyDCCDcQCAQExCzAJBgUrDgMCGgUAMIIJswYJKoZI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\n8svonCL2b8hi1BjI0QJB7eFmZw49mWOfd4UI63E8hccqkXhbTOju6Bu8ng==</sign>\n</body>\n</html>";

    public static Element createICBCCMPRoot(String transCode) {
        EBContext context = EBContext.getContext();
        String fSeqno = context.getBizSeqID();
        Element root = JDomUtils.createRoot((String)"CMS");
        Element eb = JDomUtils.addChild((Element)root, (String)"eb");
        Element pub = JDomUtils.addChild((Element)eb, (String)"pub");
        JDomUtils.addChild((Element)pub, (String)"TransCode", (String)transCode);
        IParameter parameter = context.getParameter();
        JDomUtils.addChild((Element)pub, (String)"CIS", (String)parameter.getBankParameter("userID"));
        JDomUtils.addChild((Element)pub, (String)"BankCode", (String)"102");
        JDomUtils.addChild((Element)pub, (String)"ID", (String)parameter.getBankParameter("authNo"));
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        if (StrUtil.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)pub, (String)"TranTime", (String)DateUtil.formatDate((Date)new Date(), (String)"HHmmssSSS"));
        JDomUtils.addChild((Element)pub, (String)"fSeqno", (String)fSeqno);
        return root;
    }

    public static Element createICBCCMPRootForPay(String transCode, String bankBatchSeqId) {
        EBContext context = EBContext.getContext();
        Element root = JDomUtils.createRoot((String)"CMS");
        Element eb = JDomUtils.addChild((Element)root, (String)"eb");
        Element pub = JDomUtils.addChild((Element)eb, (String)"pub");
        JDomUtils.addChild((Element)pub, (String)"TransCode", (String)transCode);
        IParameter parameter = context.getParameter();
        JDomUtils.addChild((Element)pub, (String)"CIS", (String)parameter.getBankParameter("userID"));
        JDomUtils.addChild((Element)pub, (String)"BankCode", (String)"102");
        JDomUtils.addChild((Element)pub, (String)"ID", (String)parameter.getBankParameter("authNo"));
        String signDate4Test = parameter.getBankParameter("signDate4Test");
        if (StrUtil.isEmpty((String)signDate4Test)) {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        } else {
            JDomUtils.addChild((Element)pub, (String)"TranDate", (String)signDate4Test);
        }
        JDomUtils.addChild((Element)pub, (String)"TranTime", (String)DateUtil.formatDate((Date)new Date(), (String)"HHmmssSSS"));
        JDomUtils.addChild((Element)pub, (String)"fSeqno", (String)bankBatchSeqId);
        return root;
    }

    public static String createMessageWithHead(String xmlcontent, String transCode) {
        return ICBC_CMP_Packer.createMessageWithHead(xmlcontent, transCode, "0.0.0.1");
    }

    public static String createMessageWithHead(String xmlcontent, String transCode, String version) {
        return ICBC_CMP_Packer.createMessageWithHead(xmlcontent, transCode, version, 0);
    }

    public static String createMessageWithHead(String xmlcontent, String transCode, String version, int zipFlag) {
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String user_id = parameter.getBankParameter("userID");
        String auth_no = parameter.getBankParameter("authNo");
        String packageID = context.getBizSeqID();
        StringBuilder sb = new StringBuilder();
        sb.append("Version=").append(version).append("&");
        sb.append("TransCode=").append(transCode).append("&");
        sb.append("BankCode=").append("102").append("&");
        sb.append("GroupCIS=").append(user_id).append("&");
        sb.append("zipFlag=").append(zipFlag).append("&");
        sb.append("ID=").append(auth_no).append("&");
        sb.append("PackageID=").append(packageID).append("&");
        sb.append("Cert=").append("").append("&");
        sb.append("reqData=").append(xmlcontent);
        return sb.toString();
    }

    public static String createMessageWithHeadForPay(String xmlcontent, String transCode, String version, int zipFlag, String packageID) {
        EBContext context = EBContext.getContext();
        IParameter parameter = context.getParameter();
        String user_id = parameter.getBankParameter("userID");
        String auth_no = parameter.getBankParameter("authNo");
        StringBuilder sb = new StringBuilder();
        sb.append("Version=").append(version).append("&");
        sb.append("TransCode=").append(transCode).append("&");
        sb.append("BankCode=").append("102").append("&");
        sb.append("GroupCIS=").append(user_id).append("&");
        sb.append("zipFlag=").append(zipFlag).append("&");
        sb.append("ID=").append(auth_no).append("&");
        sb.append("PackageID=").append(packageID).append("&");
        sb.append("Cert=").append("").append("&");
        sb.append("reqData=").append(xmlcontent);
        return sb.toString();
    }

    public static String sign(String reqstMsg, List<PaymentInfo> paymentInfoList) {
        reqstMsg = KDProcessorFactory.getInstance().processPaymentInfoAndRepack(reqstMsg, paymentInfoList);
        return ICBC_CMP_Packer.sign(reqstMsg);
    }

    /*
     * Exception decompiling
     */
    public static String sign(String reqstMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String parseSignRspMsg(String signRspMsg) {
        if (StrUtil.isEmpty((String)signRspMsg)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25,\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e3a\u7a7a", (String)"ICBC_CMP_Packer_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        int index = signRspMsg.indexOf("errorCode=");
        if (-1 != index) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25,%s", (String)"ICBC_CMP_Packer_9", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), signRspMsg));
        }
        Element root = JDomUtils.string2Root((String)("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + signRspMsg), (String)"UTF-8");
        Element body = root.getChild("body");
        if (null == body) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2d\u6ca1\u6709body\u8282\u70b9\u3002", (String)"ICBC_CMP_Packer_3", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        Element sign = body.getChild("sign");
        if (null == sign) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25\uff0c\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2d\u6ca1\u6709sign\u8282\u70b9\u3002", (String)"ICBC_CMP_Packer_4", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        String signed = sign.getTextTrim();
        if (StrUtil.isEmpty((String)signed)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7b7e\u540d\u5931\u8d25,\u7b7e\u540d\u54cd\u5e94\u5185\u5bb9\u4e2dsign\u8282\u70b9\u5185\u5bb9\u4e3a\u7a7a", (String)"ICBC_CMP_Packer_5", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]));
        }
        logger.info("\u7b7e\u540d\u6210\u529f");
        return signed;
    }

    public static void openConnection(IConnection connection) {
        try {
            EBContext.getContext().setConnection(connection);
            connection.openConnection();
        }
        catch (IOException e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6253\u5f00\u8fde\u63a5\u5f02\u5e38\uff1a%s\u3002", (String)"ICBC_CMP_Packer_10", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public static boolean isSSLProxyConnection() {
        return EBContext.getContext().getProxyType() != null;
    }

    public static void send(OutputStream outputStream, String requestStr, String bizSeqId) {
        if (ICBC_CMP_Packer.isSSLProxyConnection()) {
            SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
            connection.sendMsg(outputStream, requestStr);
        } else {
            IOUtils.sendFully((OutputStream)outputStream, (String)requestStr);
        }
    }

    public static String recv(InputStream inputStream, String bizSeqId) {
        if (ICBC_CMP_Packer.isSSLProxyConnection()) {
            try {
                SSLConnection connection = (SSLConnection)EBContext.getContext().getConnection();
                return connection.getResponse(inputStream);
            }
            catch (Exception e) {
                if (StringUtils.isEmpty((String)e.getMessage())) {
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u83b7\u53d6\u8f93\u5165\u6d41\u5f02\u5e38\u3002", (String)"ICBC_CMP_Packer_7", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), (Throwable)e);
                }
                if (e instanceof EBServiceException) {
                    throw EBExceiptionUtil.serviceException((String)e.getMessage(), (String)((EBServiceException)e).getErrorCode(), (Throwable)e);
                }
                throw EBExceiptionUtil.serviceException((String)e.getMessage(), (Throwable)e);
            }
        }
        return IOUtils.readFully((InputStream)inputStream);
    }
}

