/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.balance;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.icbc.cmp.BankBusinessConfig;
import kd.ebg.aqap.banks.icbc.cmp.service.ICBC_CMP_Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QFACCTMEASParser {
    public void parseQFACCTMEASMessage(BalanceInfo balance, String rspStr) {
        String encoding;
        String retMsg = ICBC_CMP_Parser.decodeRsp(rspStr, true);
        Element root = JDomUtils.string2Root((String)retMsg, (String)(encoding = RequestContextUtils.getCharset()));
        Element eb = root.getChild("eb");
        Element pub = eb.getChild("pub");
        BankResponse headRsp = ICBC_CMP_Parser.parseHeader(pub);
        if (!"0".equals(headRsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u53ef\u7528\u4f59\u989d\u4fe1\u606f\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"QFACCTMEASParser_1", (String)"ebg-aqap-banks-icbc-cmp", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{headRsp.getResponseCode(), headRsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element out = eb.getChild("out");
        String currType = out.getChildTextTrim("CurrType");
        if (!currType.equalsIgnoreCase(balance.getBankCurrency())) {
            return;
        }
        if (BankBusinessConfig.isAvailableBalanceFromQFACCTMEASAvaPayAmt()) {
            String AvaPayAmt = JDomUtils.getChildText((Element)out, (String)"AvaPayAmt");
            balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)AvaPayAmt));
        } else if (BankBusinessConfig.isAvailableBalanceFromQFACCTMEASReserved2()) {
            String RepReserved2 = JDomUtils.getChildText((Element)out, (String)"RepReserved2");
            String[] RepReserved2Arr = RepReserved2.split("\\|", -1);
            if (RepReserved2Arr.length >= 4) {
                balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)RepReserved2Arr[2]));
            }
        } else {
            String ABanlance = JDomUtils.getChildText((Element)out, (String)"ABanlance");
            balance.setAvailableBalance(ParserUtils.convertCentStr2Yuan((String)ABanlance));
        }
    }
}

