/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.icbc.cmp.service.utils;

import com.google.common.collect.Maps;
import java.net.URL;
import java.util.List;
import java.util.Map;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;

public class BusTypeUtils {
    private static BusTypeUtils instance;
    public static final String fileName = "BusType.xml";
    public static final Map<String, String> busTypeMap;

    public static BusTypeUtils getInstance() {
        if (null == instance) {
            instance = new BusTypeUtils();
        }
        return instance;
    }

    private BusTypeUtils() {
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            URL resource = this.getClass().getClassLoader().getResource(fileName);
            doc = builder.build(resource);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
        Element root = doc.getRootElement();
        List cardtypeList = root.getChildren("BusInfo");
        for (int i = 0; i < cardtypeList.size(); ++i) {
            Element busInfo = (Element)cardtypeList.get(i);
            String useCn = busInfo.getChildTextTrim("useCn");
            String busType = busInfo.getChildTextTrim("busType");
            busTypeMap.put(useCn, busType);
        }
    }

    public static void main(String[] args) {
        BusTypeUtils busTypeUtils = BusTypeUtils.getInstance();
        System.out.println(busTypeMap.toString());
    }

    static {
        busTypeMap = Maps.newHashMapWithExpectedSize((int)5);
    }
}

