/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hfb.dc.services.detail;

import java.time.LocalDate;
import kd.ebg.aqap.banks.hfb.dc.util.HFB_Packer;
import kd.ebg.aqap.banks.hfb.dc.util.PageConstant;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailPacker {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailPacker.class);

    public static String packDetail(BankDetailRequest request, String pageTag) throws EBServiceException {
        Element root = HFB_Packer.buildHead(Sequence.gen14Sequence());
        Element opReq = root.getChild("opReq");
        Element reqParam = JDomUtils.addChild((Element)opReq, (String)"reqParam");
        BankAcnt acnt = request.getAcnt();
        String accNo = acnt.getAccNo();
        JDomUtils.addChild((Element)reqParam, (String)"ACNO", (String)accNo);
        JDomUtils.addChild((Element)reqParam, (String)"BIZH", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)reqParam, (String)"QSRQ", (String)DateUtil.formatDate((LocalDate)request.getStartDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"ZZRQ", (String)DateUtil.formatDate((LocalDate)request.getEndDate(), (String)"yyyyMMdd"));
        JDomUtils.addChild((Element)reqParam, (String)"MIFS", (String)"0");
        JDomUtils.addChild((Element)reqParam, (String)"MAFS", (String)"99999999999999.99");
        JDomUtils.addChild((Element)reqParam, (String)"turnPageBeginPos", (String)pageTag);
        JDomUtils.addChild((Element)reqParam, (String)"RNUM", (String)PageConstant.Size.toString());
        String rqstStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)RequestContextUtils.getCharset());
        return rqstStr;
    }
}

