/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.adbc.dc.services.balance;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.adbc.dc.services.Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceParser.class);

    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) {
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BalanceInfo balanceInfo = new BalanceInfo();
        if (StringUtils.isEmpty((String)rspStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]));
        }
        BankResponse bankResponse = Parser.parseResponse(rspStr);
        if ("S0000".equals(bankResponse.getResponseCode())) {
            this.getBalance(rspStr, balanceInfo, rqst.getBankAcntList());
            BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)rqst.getBankCurrency());
            ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
            balanceInfos.add(balanceInfo);
            bankBalanceResponse.setBalances(balanceInfos);
            this.logger.info("\u89e3\u6790\u4f59\u989d\u67e5\u8be2\u62a5\u6587\u6210\u529f-----");
            return bankBalanceResponse;
        }
        throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage()));
    }

    public void getBalance(String rspStr, BalanceInfo balanceInfo, List<BankAcnt> bankAcntList) {
        int index = rspStr.indexOf("}\r\n");
        String body = rspStr.substring(index + 1, rspStr.length());
        String a = body.substring(body.indexOf(" xmlns="), body.indexOf("\">") + 1);
        String context = body.replace(a, "");
        try {
            Element bankDate = JDomUtils.string2Root((String)context, (String)"UTF-8");
            Element accountBalance = bankDate.getChild("AccountBalance");
            String str_balance = accountBalance.getChildTextTrim("Balance");
            String str_doBalance = accountBalance.getChildTextTrim("DoBalance");
            String account = accountBalance.getChildTextTrim("Account");
            BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, bankAcntList, (String)account);
            BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)str_doBalance);
            BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
            BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)str_balance);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u4f59\u989d\u62a5\u6587\u5931\u8d25\u3002", (String)"TodayBalanceParser_3", (String)"ebg-aqap-banks-adbc-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

