/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zrc.dc.services.detail;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zrc.dc.ZrcDcBankBusinessConfig;
import kd.ebg.aqap.banks.zrc.dc.services.detail.DetailHelper;
import kd.ebg.aqap.banks.zrc.dc.util.Request;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayDetailImpl
extends AbstractDetailImpl
implements IDetail {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(TodayDetailImpl.class);
    private static int pageSize = 20;

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/eweb-query.BSCurDetailOp.do?";
        s = s + "userPassword=" + RequestContextUtils.getParameter().getBankParameter("user_password") + "&SIGDATA=1";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
        super.configFactory(factory);
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        EBBankDetailResponse detailResponse = super.doBiz(request);
        detailInfos.addAll(detailResponse.getDetails());
        return new EBBankDetailResponse(detailInfos);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        Element root = new Element("ROOT");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)root, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"opName", (String)"BSCurDetailOp");
        Element body = new Element("ReqParam");
        String Areacode = bankDetailRequest.getAcnt().getAreaCode();
        JDomUtils.addChild((Element)body, (String)"Area_code", (String)Areacode);
        String accNo = bankDetailRequest.getAcnt().getAccNo();
        JDomUtils.addChild((Element)body, (String)"Account_num", (String)accNo);
        String cur = bankDetailRequest.getBankCurrency();
        JDomUtils.addChild((Element)body, (String)"Account_cur", (String)cur);
        JDomUtils.addChild((Element)body, (String)"userID", (String)RequestContextUtils.getBankParameterValue((String)"userid"));
        JDomUtils.addChild((Element)body, (String)"PackageID", (String)Sequence.gen14Sequence());
        JDomUtils.addChild((Element)opReq, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String rspStr) {
        return new EBBankDetailResponse(this.parseDetail(bankDetailRequest, rspStr));
    }

    private List<DetailInfo> parseDetail(BankDetailRequest bankDetailRequest, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        Element opRep = JDomUtils.getChildElement((Element)root, (String)"opRep");
        Element opResult = JDomUtils.getChildElement((Element)opRep, (String)"opResult");
        String retCode = JDomUtils.getChildText((Element)opResult, (String)"retCode");
        String errMsg = JDomUtils.getChildText((Element)opResult, (String)"errMsg");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>();
        String Account_num = JDomUtils.getChildText((Element)opResult, (String)"Account_num");
        if (retCode == null || !"0".equals(retCode)) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff08" + retCode + "\uff09\uff1a" + errMsg);
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u9519\u8bef\uff08%1$s\uff09\uff1a%2$s", (String)"TodayDetailImpl_4", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), retCode, errMsg));
        }
        Element opResultSet = JDomUtils.getChildElement((Element)opRep, (String)"opResultSet");
        List list = opResultSet.getChildren("opResult");
        if (list != null && list.size() > 0) {
            logger.info("\u94f6\u884c\u8fd4\u56de\u8bb0\u5f55\u6761\u6570\uff1a" + list.size());
            HashMap countMap = Maps.newHashMapWithExpectedSize((int)16);
            for (int i = 0; i < list.size(); ++i) {
                DetailInfo detail = new DetailInfo();
                Element row = (Element)list.get(i);
                String transDate = row.getChildTextTrim("Trans_date");
                String Check_num = row.getChildTextTrim("Check_num");
                String Trans_abstr = row.getChildTextTrim("Trans_abstr");
                String Amount = Request.processBalance(row.getChildTextTrim("Amount"));
                String sign = row.getChildTextTrim("sign");
                String Balance = row.getChildTextTrim("Balance");
                if (StringUtils.isNotEmpty((String)Balance)) {
                    Balance = Request.processBalance(Balance);
                }
                String Rec_Account_num = row.getChildTextTrim("Rec_Account_num");
                String oppName = row.getChildTextTrim("Rec_Account_name");
                String Trans_type = row.getChildTextTrim("Trans_type");
                String Yt = row.getChildTextTrim("Yt");
                String transTimeStr = "";
                try {
                    String current = transDate.replace("-", "");
                    String tempStr = current.replace(":", "");
                    transTimeStr = tempStr.substring(0, 14);
                    String dateStr = tempStr.substring(0, 8);
                    detail.setTransDate(LocalDate.parse(dateStr, DateTimeFormatter.ofPattern("yyyyMMdd")));
                    LocalDateTime transDateTime = LocalDateTime.parse(transTimeStr, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
                    detail.setTransTime(transDateTime);
                }
                catch (Exception var34) {
                    logger.info("\u89e3\u6790\u94f6\u884c\u65e5\u671f\u5f02\u5e38\uff1a" + transTimeStr);
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u65e5\u671f\u9519\u8bef%s", (String)"TodayDetailImpl_5", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), transTimeStr), (Throwable)var34);
                }
                if (StringUtils.isNotEmpty((String)Balance)) {
                    detail.setBalance(new BigDecimal(Balance));
                }
                detail.setAccNo(Account_num);
                detail.setOppAccNo(Rec_Account_num);
                detail.setBankDetailNo(Check_num);
                detail.setOppAccName(oppName);
                String currency = bankDetailRequest.getBankCurrency();
                detail.setCurrency(currency);
                detail.setTransType(Trans_type);
                detail.setExplanation(Yt);
                if ("1".equals(sign)) {
                    detail.setDebitAmount(new BigDecimal(Amount));
                    detail.setCreditAmount(new BigDecimal("0.00"));
                } else if ("2".equals(sign)) {
                    detail.setCreditAmount(new BigDecimal(Amount));
                    detail.setDebitAmount(new BigDecimal("0.00"));
                } else {
                    logger.info("\u65e0\u6cd5\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7" + sign);
                    throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u501f\u8d37\u6807\u5fd7%s", (String)"TodayDetailImpl_6", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]), sign));
                }
                if (!StringUtils.isEmpty((String)Trans_abstr) && Trans_abstr.indexOf("KD_") != -1) {
                    String tmp = DetailHelper.parseKDDetailNo(Trans_abstr);
                    detail.setPayBankDetailSeqID(tmp);
                }
                String jsonStr = MatchRule.getInstance().getDetailJsonWithStructuredData(row);
                JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                String transDateStr = LocalDateUtil.formatDate((LocalDate)detail.getTransDate());
                jsonObject.put("Trans_date", (Object)transDateStr);
                if (ZrcDcBankBusinessConfig.isNewApi(bankDetailRequest.getAcnt().getBankLoginId(), RequestContext.get().getTenantId())) {
                    String cdFlag = jsonObject.getString("ReqReserved3");
                    if (!StringUtils.isEmpty((String)Trans_abstr)) {
                        jsonObject.put("cdFlag", (Object)cdFlag);
                    } else {
                        jsonObject.put("cdFlag", (Object)"e");
                    }
                    jsonStr = jsonObject.toJSONString();
                }
                detail.setJsonMap(jsonObject.toJSONString());
                String receiptNo = MatchRule.getInstance().getReceiptNo(bankDetailRequest.getAcnt().getAccNo(), transDateStr, jsonStr);
                if (countMap.containsKey(receiptNo)) {
                    int count = (Integer)countMap.get(receiptNo) + 1;
                    countMap.put(receiptNo, count);
                    receiptNo = receiptNo + "-" + String.format("%04d", count);
                } else {
                    countMap.put(receiptNo, 0);
                }
                detail.setReceiptNo(receiptNo);
                detail.setBankDetailNo(Check_num);
                detailInfos.add(detail);
            }
        }
        return detailInfos;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "BSCurDetailOp";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5f53\u65e5\u660e\u7ec6\u8bf7\u6c42", (String)"TodayDetailImpl_3", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]);
    }
}

