/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zrc.dc.services.payment.pay;

import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zrc.dc.ZrcDcBankBusinessConfig;
import kd.ebg.aqap.banks.zrc.dc.services.payment.pay.PaymentHelper;
import kd.ebg.aqap.banks.zrc.dc.util.Request;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.utils.datetime.DateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos, String code) {
        Element root = new Element("ROOT");
        Element opReq = new Element("opReq");
        JDomUtils.addChild((Element)root, (Element)opReq);
        JDomUtils.addChild((Element)opReq, (String)"opName", (String)code);
        if (paymentInfos.length > 1) {
            String errorMsg = ResManager.loadKDString((String)"\u53ea\u652f\u6301\u5355\u7b14\u8f6c\u8d26\u4ea4\u6613", (String)"PayPacker_0", (String)"ebg-aqap-banks-zrc-dc", (Object[])new Object[0]);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        Element body = new Element("ReqParam");
        PaymentInfo paymentInfo = paymentInfos[0];
        JDomUtils.addChild((Element)body, (String)"Pay_Dep_name", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)body, (String)"Pay_Dep_Acc", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)body, (String)"Area_code", (String)paymentInfo.getAreaCode());
        JDomUtils.addChild((Element)body, (String)"Pay_Dep_branch", (String)paymentInfo.getBankName());
        JDomUtils.addChild((Element)body, (String)"Rec_Dep_name", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)body, (String)"Rec_Dep_Acc", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)body, (String)"Rec_Area_Code", (String)(paymentInfo.is2SameBank() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"Rec_Dep_branch", (String)paymentInfo.getIncomeBankName());
        Date now = new Date();
        String c = ZrcDcBankBusinessConfig.popResult();
        JDomUtils.addChild((Element)body, (String)"Trans_time", (String)DateUtil.formatDate((Date)now, (String)"yyyyMMddHHmmss"));
        JDomUtils.addChild((Element)body, (String)"Serial_no", (String)paymentInfo.getBankDetailSeqId());
        JDomUtils.addChild((Element)body, (String)"PayAmt", (String)Request.Amt2Str(paymentInfo.getAmount()));
        JDomUtils.addChild((Element)body, (String)"Account_cur", (String)paymentInfo.getCurrency());
        JDomUtils.addChild((Element)body, (String)"Pay_Use", (String)paymentInfo.getUseCn());
        JDomUtils.addChild((Element)body, (String)"Pay_type", (String)(paymentInfo.is2Urgent() ? "1" : "0"));
        JDomUtils.addChild((Element)body, (String)"Submit_Log_id", (String)"00001");
        JDomUtils.addChild((Element)body, (String)"Area_name", (String)paymentInfo.getAccCity());
        JDomUtils.addChild((Element)body, (String)"Rec_Area_name", (String)paymentInfo.getIncomeCity());
        JDomUtils.addChild((Element)body, (String)"Branch_code", (String)"");
        JDomUtils.addChild((Element)body, (String)"Pay_Password", (String)"");
        JDomUtils.addChild((Element)body, (String)"User_Rem", (String)("2".equalsIgnoreCase(c) ? "" : paymentInfo.getExplanation()));
        JDomUtils.addChild((Element)body, (String)"Pay_NetCode", (String)"");
        JDomUtils.addChild((Element)body, (String)"Pay_BranchNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"Pay_BranchId", (String)"");
        JDomUtils.addChild((Element)body, (String)"Rec_BranchNo", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)body, (String)"Rec_BranchId", (String)"");
        JDomUtils.addChild((Element)body, (String)"Rec_DispsNo", (String)"");
        JDomUtils.addChild((Element)body, (String)"PostScript", (String)("3".equalsIgnoreCase(c) ? "" : paymentInfo.getExplanation()));
        JDomUtils.addChild((Element)body, (String)"Transfer_Type", (String)"");
        JDomUtils.addChild((Element)body, (String)"userID", (String)RequestContextUtils.getBankParameterValue((String)"userid"));
        JDomUtils.addChild((Element)body, (String)"PackageID", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)body, (String)"ReqReserved1", (String)PaymentHelper.getKDFlag(paymentInfo.getBankDetailSeqId()));
        JDomUtils.addChild((Element)opReq, (Element)body);
        String encoding = RequestContextUtils.getCharset();
        String RspMsg = JDomUtils.root2String((Element)root, (String)encoding);
        return RspMsg;
    }
}

