/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.financing;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.time.format.DateTimeFormatter;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.util.JsonUtil;
import kd.ebg.aqap.banks.cmb.opa.util.MsgPacker;
import kd.ebg.aqap.banks.cmb.opa.util.MsgParser;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.financing.atomic.AbstractFinancingImpl;
import kd.ebg.aqap.business.financing.atomic.IQueryBuyFinancing;
import kd.ebg.aqap.business.financing.atomic.IQueryRedeemFinancing;
import kd.ebg.aqap.business.financing.bank.BankFinancingRequest;
import kd.ebg.aqap.business.financing.bank.EBBankFinancingResponse;
import kd.ebg.aqap.business.financing.util.FinancingUtil;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.FinancingState;
import kd.ebg.aqap.common.model.financing.FinancingInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class QueryFinancingImpl
extends AbstractFinancingImpl
implements IQueryBuyFinancing,
IQueryRedeemFinancing {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryFinancingImpl.class);

    public EBBankFinancingResponse doBiz(BankFinancingRequest request) {
        this.setLastPage(false);
        EBBankFinancingResponse response = new EBBankFinancingResponse();
        while (!this.isLastPage()) {
            try {
                String rqstStr = this.pack(request);
                String rspStr = PostUtil.sendMsg(rqstStr);
                response = this.parse(request, rspStr);
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((Throwable)e);
            }
        }
        return response;
    }

    public String pack(BankFinancingRequest bankFinancingRequest) {
        FinancingInfo info = (FinancingInfo)bankFinancingRequest.getInfos().get(0);
        JSONObject body = new JSONObject();
        JSONObject ntwauqdix = new JSONObject();
        ntwauqdix.put("bgndat", (Object)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ntwauqdix.put("enddat", (Object)info.getSubmitSuccessTime().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        ntwauqdix.put("minamt", (Object)"");
        ntwauqdix.put("maxamt", (Object)"");
        String ctnkey = RequestContextUtils.getRunningParam((String)"ctnkey");
        ntwauqdix.put("ctnkey", (Object)(StringUtils.isEmpty((String)ctnkey) ? "" : ctnkey));
        body.put("ntwauqdix", (Object)ntwauqdix);
        String bizCode = this.getBizCode();
        JSONObject head = JsonUtil.getHead(bizCode, Sequence.genSequence());
        JSONObject request = JsonUtil.getrequest(head, body);
        return MsgPacker.getSendMsg(request, this.logger, bizCode);
    }

    public EBBankFinancingResponse parse(BankFinancingRequest bankFinancingRequest, String s) {
        String respStr = MsgParser.getReceMsg(s, this.logger);
        return this.parse(respStr, bankFinancingRequest);
    }

    public EBBankFinancingResponse parse(String respStr, BankFinancingRequest bankFinancingRequest) {
        EBBankFinancingResponse result = new EBBankFinancingResponse();
        BankResponse response = MsgParser.getResponse(respStr, this.logger);
        if (!"SUC0000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u5f02\u5e38\uff1a%s\u3002", (String)"QueryFinancingImpl_13", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), response.getResponseMessage()));
        }
        JSONObject request = JSONObject.parseObject((String)respStr);
        JSONObject resp = request.getJSONObject("response");
        JSONObject body = resp.getJSONObject("body");
        JSONObject ntwauqdix = body.getJSONObject("ntwauqdix");
        if (ntwauqdix == null || StringUtils.isEmpty((String)ntwauqdix.getString("ctnkey"))) {
            this.setLastPage(true);
        } else {
            this.setLastPage(false);
            RequestContextUtils.setRunningParam((String)"ctnkey", (String)ntwauqdix.getString("ctnkey"));
        }
        JSONArray array = body.getJSONArray("ntwauqdiz");
        List infos = bankFinancingRequest.getInfos();
        FinancingInfo info = (FinancingInfo)infos.get(0);
        if (array != null && array.size() > 0) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject jsonObject = array.getJSONObject(i);
                String yurref = jsonObject.getString("yurref");
                if (!info.getBankFinancingSeqId().equalsIgnoreCase(yurref)) continue;
                String accno = jsonObject.getString("eacnbr");
                if (!info.getAccNo().equalsIgnoreCase(accno)) {
                    this.logger.error("\u4e1a\u52a1\u53c2\u8003\u53f7{}\u548c\u8d26\u53f7{}\u4e0d\u5339\u914d", new Object[]{yurref, info.getAccNo()});
                    throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e1a\u52a1\u53c2\u8003\u53f7\u548c\u8d26\u53f7\u4e0d\u5339\u914d\u3002", (String)"QueryFinancingImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]));
                }
                this.setLastPage(true);
                String rtnNar = jsonObject.getString("reqnbr");
                String buscod = jsonObject.getString("buscod");
                String rqscod = jsonObject.getString("rqscod");
                String ripcod = jsonObject.getString("ripcod");
                String ccynbr = jsonObject.getString("ccynbr");
                String bbknbr = jsonObject.getString("bbknbr");
                String trsamt = jsonObject.getString("trsamt");
                String reqSts = jsonObject.getString("reqsts");
                String rtnFlg = jsonObject.getString("rtnflg");
                String oprdat = jsonObject.getString("oprdat");
                info.setBackAmount(trsamt);
                info.setAreaCode(bbknbr);
                boolean isSuccess = false;
                if ("BAC".equalsIgnoreCase(reqSts) || "BNK".equalsIgnoreCase(reqSts)) {
                    FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u53d7\u7406", (String)"QueryFinancingImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("AUT".equals(reqSts)) {
                    FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u7b49\u5f85\u5ba1\u6279", (String)"QueryFinancingImpl_3", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("ACK".equals(reqSts)) {
                    FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)ResManager.loadKDString((String)"\u7b49\u5f85\u786e\u8ba4", (String)"QueryFinancingImpl_4", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                } else if ("BCF".equals(reqSts) || "WUF".equals(reqSts) || "APD".equals(reqSts) || "WCF".equals(reqSts) || "APW".equals(reqSts)) {
                    FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)"", (String)rtnFlg, (String)rtnNar);
                } else if ("FIN".equalsIgnoreCase(reqSts)) {
                    if ("F".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryFinancingImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("S".equalsIgnoreCase(rtnFlg)) {
                        isSuccess = true;
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryFinancingImpl_6", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("B".equalsIgnoreCase(rtnFlg)) {
                        isSuccess = true;
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUCCESS, (String)ResManager.loadKDString((String)"\u9000\u7968", (String)"QueryFinancingImpl_7", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("R".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u5ba1\u6279\u5426\u51b3", (String)"QueryFinancingImpl_8", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("C".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u64a4\u9500", (String)"QueryFinancingImpl_9", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("D".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25,\u4f01\u4e1a\u8fc7\u671f\u4e0d\u5ba1\u6279", (String)"QueryFinancingImpl_10", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("X".equalsIgnoreCase(rtnFlg) || "M".equalsIgnoreCase(rtnFlg) || "V".equalsIgnoreCase(rtnFlg) || "L".equalsIgnoreCase(rtnFlg) || "J".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryFinancingImpl_5", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)rtnFlg, (String)rtnNar);
                    } else if ("H".equalsIgnoreCase(rtnFlg) || "E".equalsIgnoreCase(rtnFlg) || "N".equalsIgnoreCase(rtnFlg)) {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.SUBMITED, (String)"", (String)rtnFlg, (String)rtnNar);
                    } else {
                        FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryFinancingImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                    }
                } else {
                    FinancingUtil.setState((FinancingInfo)info, (FinancingState)FinancingState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"QueryFinancingImpl_11", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), (String)response.getResponseCode(), (String)response.getResponseMessage());
                }
                result.setInfos(infos);
                return result;
            }
        } else {
            result.setInfos(infos);
        }
        return result;
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "NTQRYQDI";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u7efc\u5408\u67e5\u8be2\u63a5\u53e3\u4ee5\u53ca\u5f53\u524d\u6301\u4ed3\u4fe1\u606f\u67e5\u8be2\u63a5\u53e3\u3002", (String)"QueryFinancingImpl_12", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public boolean match(BankFinancingRequest request) {
        return true;
    }
}

