/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmb.opa.service.payment.salary;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmb.opa.service.payment.salary.PayPacker;
import kd.ebg.aqap.banks.cmb.opa.service.payment.salary.PayParser;
import kd.ebg.aqap.banks.cmb.opa.service.payment.salary.SalaryPaymentQueryImpl;
import kd.ebg.aqap.banks.cmb.opa.util.PostUtil;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class SalaryPaymentImpl
extends AbstractPayImpl
implements IPay {
    private PayPacker payPacker = new PayPacker();
    private PayParser payParser = new PayParser();

    public EBBankPayResponse doBiz(BankPayRequest request) {
        String rsqt;
        try {
            rsqt = this.pack(request);
        }
        catch (Exception ex) {
            throw EBExceiptionUtil.payFailException((String)String.format(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8bf7\u6c42\u8fde\u63a5\u94f6\u884c\u524d\u5f02\u5e38:%s", (String)"SalaryPaymentImpl_2", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]), ex.getMessage()), (Throwable)ex);
        }
        EBBankPayResponse response = null;
        try {
            String rspStr = PostUtil.sendMsgForPay(rsqt);
            response = this.parse(request, rspStr);
        }
        catch (Throwable t) {
            EBContext.getContext().setThrowableAfterSend(t);
            EBExceiptionUtil.serviceException((Throwable)t);
        }
        return response;
    }

    public int getBatchSize() {
        return 1000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SalaryPaymentQueryImpl.class;
    }

    public String getDeveloper() {
        return ResManager.loadKDString((String)"\u738b\u6dbf", (String)"SalaryPaymentImpl_0", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public String getBizCode() {
        return "NTAGCSAL";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4ee3\u53d1\u5de5\u8d44\u7ecf\u529e", (String)"SalaryPaymentImpl_1", (String)"ebg-aqap-banks-cmb-opa", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest bankPayRequest) {
        PaymentInfo[] paymentInfos = bankPayRequest.getPaymentInfoAsArray();
        String rsqt = this.payPacker.packPay(paymentInfos);
        return rsqt;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        this.payParser.parsePay(bankPayRequest.getPaymentInfoAsArray(), s);
        return new EBBankPayResponse(bankPayRequest.getPaymentInfos());
    }

    public boolean match(PaymentInfo paymentInfo) {
        return false;
    }
}

