/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.boc.net.service.balance;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.boc.net.BankBusinessConfig;
import kd.ebg.aqap.banks.boc.net.service.Packer;
import kd.ebg.aqap.banks.boc.net.service.Parser;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccess;
import kd.ebg.aqap.banks.boc.net.service.login.LoginAccessManager;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.ITodayBatchDepositBalBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DepositBalanceImpl
extends AbstractBalanceImpl
implements ITodayBatchDepositBalBalance {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DepositBalanceImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pack(BankBalanceRequest bankBalanceRequest) {
        List bankAcntList = bankBalanceRequest.getBankAcntList();
        bankAcntList = bankAcntList.stream().filter(bankAcnt -> BankBusinessConfig.isQueryDepositBal(bankAcnt.getAccNo())).collect(Collectors.toList());
        LoginAccess la = LoginAccessManager.searchLock();
        try {
            String token = la.getToken();
            Element root = Packer.getHeader(token, "b2e0050");
            Element trans = JDomUtils.addChild((Element)root, (String)"trans");
            Element trn = JDomUtils.addChild((Element)trans, (String)"trn-b2e0050-rq");
            for (BankAcnt acnt : bankAcntList) {
                Element rq = JDomUtils.addChild((Element)trn, (String)"b2e0050-rq");
                Element account = JDomUtils.addChild((Element)rq, (String)"account");
                JDomUtils.addChild((Element)account, (String)"ibknum", (String)acnt.getCnaps());
                JDomUtils.addChild((Element)account, (String)"actacn", (String)acnt.getAccNo());
            }
            String string = JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
            return string;
        }
        finally {
            try {
                la.unavailableRelease();
            }
            catch (Exception e) {
                this.logger.error("\u4e0a\u5b58\u4f59\u989d\u63a5\u53e3\u67e5\u8be2\u6253\u5305\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        Parser.parserB2eError(root);
        Element trans = root.getChild("trans");
        Element trn = trans.getChild("trn-b2e0050-rs");
        Element status = trn.getChild("status");
        String rspcod = status.getChildTextTrim("rspcod");
        String rspmsg = status.getChildTextTrim("rspmsg");
        LoginAccessManager.searchLock().checkTokenValid(rspcod);
        if (!"B001".equals(rspcod)) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rspcod, (String)rspmsg));
        }
        List elements = trn.getChildren("b2e0050-rs");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(12);
        for (Element rs : elements) {
            Element another_status = rs.getChild("status");
            String another_rspcod = another_status.getChildTextTrim("rspcod");
            String another_rspmsg = another_status.getChildTextTrim("rspmsg");
            Element account = rs.getChild("account");
            String actacn = account.getChildTextTrim("actacn");
            this.logger.info("\u89e3\u6790\u5230\u4e2d\u884c\u8fd4\u56de\u7684'\u8d26\u53f7'\u4e3a" + actacn);
            BalanceInfo balanceInfo = new BalanceInfo();
            BankAcnt bankAcnt = new BankAcnt();
            bankAcnt.setAccNo(actacn);
            balanceInfo.setBankAcnt(bankAcnt);
            balanceInfo.setBankCurrency(bankBalanceRequest.getBankCurrency());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            if (!"B001".equals(another_rspcod)) {
                balanceInfo.setError(ShowTipUtil.getResponseErrorTips((String)another_rspcod, (String)another_rspmsg));
            } else {
                String bokbal = rs.getChild("balance").getChildTextTrim("bokbal");
                this.setDepositBalance(balanceInfo, bokbal);
            }
            balances.add(balanceInfo);
        }
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "b2e0050";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4e0a\u5b58\u4f59\u989d\u67e5\u8be2", (String)"DepositBalanceImpl_0", (String)"ebg-aqap-banks-boc-net", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceRequest request) {
        LocalDate today = LocalDate.now();
        boolean matchTime = today.equals(request.getStartDate()) && today.equals(request.getEndDate());
        List bankAcntList = request.getBankAcntList();
        boolean matchConfig = bankAcntList.stream().filter(bankAcnt -> BankBusinessConfig.isQueryDepositBal(bankAcnt.getAccNo())).collect(Collectors.toList()).isEmpty();
        return matchTime && !matchConfig;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri("/B2EC/E2BServlet");
    }
}

