/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsb.dc.service.payment.individual.salary;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsb.dc.HSB_DC_Parser;
import kd.ebg.aqap.banks.hsb.dc.service.proxy.QueryPayFileDownLoad;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryPayParser {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayParser.class);

    public static EBBankPayResponse parseQueryPay(List<PaymentInfo> paymentInfos, String rspStr) throws EBServiceException {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)(rspStr = rspStr.substring(rspStr.indexOf("<ap>"))), (String)encoding);
        BankResponse rsp = HSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)rsp.getResponseCode(), (String)rsp.getResponseMessage());
            return new EBBankPayResponse(paymentInfos);
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u8fd4\u56defile_flag:\u4e3a" + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u653e\u56de\u7684\u8bb0\u5f55\u6570\u4e3a0\uff0c\u65e0\u6cd5\u786e\u5b9a\u4ea4\u6613\u72b6\u6001", (String)"QueryPayParser_10", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        String[] splits = new String[]{};
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            QueryPayFileDownLoad queryPayFileDownLoad = new QueryPayFileDownLoad();
            String content = queryPayFileDownLoad.doBiz(file_name);
            splits = StringUtils.split((String)content, (String)"|");
        } else if ("0".equalsIgnoreCase(file_flag)) {
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        } else {
            EBGBusinessUtils.setPaymentState(paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5,\u94f6\u884c\u8fd4\u56defile_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u83b7\u53d6\u4ed8\u6b3e\u6570\u636e.", (String)"QueryPayParser_11", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(paymentInfos);
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        String msg = "";
        for (int i = 1; i <= recordNum; ++i) {
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < fieldNum; ++j) {
                buffer.append(splits[fieldNum * i + j].trim());
                buffer.append("|");
            }
            msg = buffer.toString();
            logger.info("\u7b2c{}\u6761\u4ed8\u6b3e\u6570\u636e\u7684\u5185\u5bb9\uff1a{}", new Object[]{i, msg});
            String STAT = splits[fieldNum * i + 9];
            String BATCH_NO = splits[fieldNum * i + 11];
            String CARD_NO = splits[fieldNum * i + 1];
            String ACNAME = splits[fieldNum * i + 3];
            String AMT = splits[fieldNum * i + 5];
            String ERR_MSG = splits[fieldNum * i + 10];
            PaymentInfo payInfo = HSB_DC_Parser.findPaymentInfo(paymentInfos, BATCH_NO, CARD_NO, ACNAME, AMT);
            if (null == payInfo) continue;
            if ("6".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayParser_7", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            if ("9".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)STAT, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayParser_8", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]));
                continue;
            }
            if ("3".equalsIgnoreCase(STAT)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayParser_9", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayParser_0", (String)"ebg-aqap-banks-hsb-dc", (Object[])new Object[0]), (String)STAT, (String)ERR_MSG);
        }
        return new EBBankPayResponse(paymentInfos);
    }
}

