/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.opa.services.payment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.czb.sap.sdk.ServiceBean;
import com.czb.sap.sdk.inf.ApiHeader;
import com.czb.sap.sdk.inf.ApiRspData;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.opa.services.utils.SdkInit;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;

public class QueryPayImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private EBGLogger logger = EBGLogger.getInstance().getLogger(QueryPayImpl.class);

    public EBBankPayResponse queryPay(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        try {
            SdkInit.init();
            PaymentInfo info = (PaymentInfo)paymentInfos.get(0);
            ApiHeader header = new ApiHeader();
            header.setMsgtype("yqwfw_queryPayStatus");
            header.setTraceno(Sequence.genSequence());
            HashMap<String, String> body = new HashMap<String, String>(5);
            body.put("tradeExSerial", info.getBankDetailSeqId());
            body.put("payAccNo", info.getAccNo());
            body.put("payCurCode", "01");
            this.logger.info("\u6d59\u5546\u540c\u6b65\u4ed8\u6b3e\u8bf7\u6c42\u6d41\u6c34\u53f7:{}", (Object)header.getTraceno());
            this.logger.info("\u6d59\u5546\u540c\u6b65\u4ed8\u6b3e\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString(body));
            ApiRspData data = ServiceBean.getService().invoke(header, body);
            String rspStr = JSON.toJSONString((Object)data);
            this.logger.info("\u6d59\u5546\u540c\u6b65\u4ed8\u6b3e\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\uff1a" + rspStr);
            return this.parse(request, rspStr);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u4ed8\u6b3e\u72b6\u6001\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public int getBatchSize() {
        return 1;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return null;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        JSONObject root = JSONObject.parseObject((String)rspStr);
        String statusCode = root.getString("resultcode");
        String statusDesc = root.getString("resultdesc");
        if (!"000000".equals(statusCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)statusCode, (String)statusDesc);
        } else {
            JSONObject jsonBody = root.getJSONObject("body");
            String status = jsonBody.getString("tradeStatus");
            if ("1".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            } else if ("2".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QueryPayImpl_2", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5904\u7406\u4e2d", (String)"QueryPayImpl_3", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            } else if ("3".equals(status)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QueryPayImpl_4", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QueryPayImpl_1", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]), (String)status, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QueryPayImpl_0", (String)"ebg-aqap-banks-zsb-opa", (Object[])new Object[0]));
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }
}

