/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zzb.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Packer;
import kd.ebg.aqap.banks.zzb.dc.services.ZZB_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        String accNo = request.getAcnt().getAccNo();
        Element ebank_root = new Element("Message");
        JDomUtils.addChild((Element)ebank_root, (Element)ZZB_Packer.buildHead(this.getBizCode(), Sequence.gen18Sequence()));
        Element body = new Element("Body");
        JDomUtils.addChild((Element)body, (String)"AcNo", (String)accNo);
        JDomUtils.addChild((Element)ebank_root, (Element)body);
        return JDomUtils.root2StringNoIndentLineNoSeparator((Element)ebank_root, (String)RequestContextUtils.getCharset());
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        EBBankBalanceResponse balanceRsp = new EBBankBalanceResponse();
        Element root = JDomUtils.string2Root((String)responseStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ZZB_Parser.parserCommonInfo(root);
        if (!"000000".equals(bankResponse.getResponseCode())) {
            String resMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u4f59\u989d\u67e5\u8be2\u5f02\u5e38\uff0c\u5f02\u5e38\u8fd4\u56de\u7801\uff1a%1$s\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"TodayBalanceImpl_6", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage());
            throw EBExceiptionUtil.serviceException((String)resMsg);
        }
        Element resBody = JDomUtils.getChildElement((Element)root, (String)"Body");
        boolean flag = false;
        BalanceInfo balanceInfo = new BalanceInfo();
        String accNo = JDomUtils.getChildText((Element)resBody, (String)"AcNo");
        String currency = JDomUtils.getChildText((Element)resBody, (String)"CurrencyCode");
        this.setBankCurrency(balanceInfo, currency);
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), accNo);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, resBody.getChildText("Balance"));
        this.setAvailableBalance(balanceInfo, resBody.getChildText("AvailBal"));
        balanceRsp.setBalances((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
        return balanceRsp;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "B2EActBalQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceImpl_5", (String)"ebg-aqap-banks-zzb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eb2e/B2EActBalQry.do?";
        s = s + "userPassword=" + RequestContextUtils.getBankParameterValue((String)"userPassword") + "&SIGDATA=0&_locale=zh_CN";
        factory.setUri(s);
        factory.setHttpHeader("content-type", "text/xml; charset=UTF-8");
    }
}

