/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.czccb.dc.service.balace;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.czccb.dc.service.Parser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    public EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceParser.class);
        EBBankBalanceResponse bankBalanceResponse = new EBBankBalanceResponse();
        BankAcnt bankAcnt = rqst.getAcnt();
        BalanceInfo balanceInfo = new BalanceInfo();
        ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
        balanceInfo.setBankAcnt(bankAcnt);
        if (StringUtils.isEmpty((String)rspStr)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\u4e3a\u7a7a", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]));
        }
        BankResponse bankResponse = Parser.parseResponse(rspStr);
        if ("000000".equalsIgnoreCase(bankResponse.getResponseCode())) {
            this.getBalance(rqst, rspStr, balanceInfo);
            balanceInfos.add(balanceInfo);
            bankBalanceResponse.setBalances(balanceInfos);
            return bankBalanceResponse;
        }
        throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u8fd4\u56de\u4e86\u6b63\u5e38\u7684\u8fd4\u56de\u7801\uff1a%1$s; \u8fd4\u56de\u7801\u63cf\u8ff0\uff1a%2$s\u3002", (String)"TodayBalanceParser_4", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
    }

    public void getBalance(BankBalanceRequest rqst, String rspStr, BalanceInfo balanceInfo) throws EBServiceException {
        EBGLogger logger = EBGLogger.getInstance().getLogger(TodayBalanceParser.class);
        int index = rspStr.indexOf("#");
        String body = rspStr.substring(index + 1, rspStr.length());
        try {
            Element bankDate = JDomUtils.string2Root((String)body, (String)"UTF-8");
            Element opRep = bankDate.getChild("opRep");
            Element opResult = opRep.getChild("opResult");
            String str_balance = opResult.getChildTextTrim("Balance");
            String str_currentBalance = opResult.getChildTextTrim("CurrentBalance");
            String str_freeBalance = opResult.getChildTextTrim("FreeBalance");
            BigDecimal bg_balance = BigDecimal.valueOf(0.0);
            BigDecimal bg_currentBalance = BigDecimal.valueOf(0.0);
            BigDecimal bg_freeBalance = BigDecimal.valueOf(0.0);
            if (!StringUtils.isEmpty((String)str_balance)) {
                bg_balance = new BigDecimal(str_balance);
            }
            if (!StringUtils.isEmpty((String)str_currentBalance)) {
                bg_currentBalance = new BigDecimal(str_currentBalance);
            }
            if (!StringUtils.isEmpty((String)str_freeBalance)) {
                bg_freeBalance = new BigDecimal(str_freeBalance);
            }
            balanceInfo.setBankCurrency(rqst.getBankCurrency());
            balanceInfo.setBalanceDateTime(LocalDateTime.now());
            balanceInfo.setAvailableBalance(bg_balance);
            balanceInfo.setCurrentBalance(bg_currentBalance);
            balanceInfo.setLastDayAvlBalance(bg_freeBalance);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u62a5\u6587\u5931\u8d25", (String)"TodayBalanceParser_3", (String)"ebg-aqap-banks-czccb-dc", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

