/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import java.time.LocalDate;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.utils.LocalDateUtil;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalancePacker {
    public String packHisBalance(BankBalanceRequest rqst) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u865a\u62df\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"HisBalancePacker_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if (AcntHelp.isCashPoolAcnt(rqst.getAcnt().getAccNo())) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u73b0\u91d1\u6c60\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"HisBalancePacker_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        if (BankBusinessConfig.isMarginAccount(rqst.getAcnt().getAccNo())) {
            throw new EBServiceException(ResManager.loadKDString((String)"\u4fdd\u8bc1\u91d1\u8d26\u6237\u4e0d\u652f\u6301\u5386\u53f2\u4f59\u989d\u67e5\u8be2\u3002", (String)"HisBalancePacker_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]));
        }
        Element root = Packer.createMessageWithHead("qryHistoryBal");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)RequestContextUtils.getRequestContext().getBankRequestSeq());
        String reqAccNo = rqst.getAcnt().getAccNo();
        JDomUtils.addChild((Element)xdataBody, (String)"acntNo", (String)reqAccNo);
        JDomUtils.addChild((Element)xdataBody, (String)"qryDate", (String)LocalDateUtil.formatDate((LocalDate)rqst.getStartDate(), (String)"yyyy-MM-dd"));
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    public String cashPoolBalancePacker(BankBalanceRequest rqst) throws EBServiceException {
        Element root = Packer.createMessageWithHead("XJCActFincDetail");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        String accNo = rqst.getAcnt().getAccNo();
        JDomUtils.addChild((Element)xdataBody, (String)"uppAcno", (String)BankBusinessConfig.getUpAccNo(accNo));
        JDomUtils.addChild((Element)xdataBody, (String)"acno", (String)accNo);
        JDomUtils.addChild((Element)xdataBody, (String)"curCode", (String)rqst.getBankCurrency());
        JDomUtils.addChild((Element)xdataBody, (String)"queryFlag", (String)"1");
        JDomUtils.addChild((Element)xdataBody, (String)"beginDate");
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

