/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.fixed.FixedBalanceParser;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.margin.MarginBalanceParser;
import kd.ebg.aqap.banks.cmbc.dc.services.balance.virtual.VirtualTodayBalanceParser;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.BalanceUtil;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceParser {
    private static EBGLogger log = EBGLogger.getInstance().getLogger(TodayBalanceParser.class);

    public static EBBankBalanceResponse parseTodayBalance(BankBalanceRequest rqst, String rspStr) throws EBServiceException {
        if (BankBusinessConfig.isVirtualAccount(rqst.getAcnt().getAccNo())) {
            BankBalanceRequest balanceRequest = new BankBalanceRequest();
            balanceRequest.setBankAcntList((List)Lists.newArrayList((Object[])new BankAcnt[]{rqst.getAcnt()}));
            balanceRequest.setCurrency(rqst.getCurrency());
            EBBankBalanceResponse balanceResponse = VirtualTodayBalanceParser.parseTodayBalance(balanceRequest, rspStr);
            return balanceResponse;
        }
        if (BankBusinessConfig.isFixedAcnt(rqst.getAcnt().getAccNo())) {
            RequestContextUtils.setRunningParam((String)"lastPageKey", (String)String.valueOf(true));
            EBBankBalanceResponse balanceResponse = FixedBalanceParser.parseTodayBalance(rqst, rspStr);
            return balanceResponse;
        }
        if (BankBusinessConfig.isMarginAccount(rqst.getAcnt().getAccNo())) {
            return MarginBalanceParser.parseTodayBalance(rqst, rspStr);
        }
        if (AcntHelp.isCashPoolAcnt(rqst.getAcnt().getAccNo())) {
            Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            BankResponse response = Parser.parseResponse(root);
            ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
            Element xDataBody = root.getChild("xDataBody");
            Element list = xDataBody.getChild("List");
            List balances = list.getChildren();
            if (balances.size() == 0) {
                return new EBBankBalanceResponse();
            }
            ArrayList<BalanceInfo> balanceInfos = new ArrayList<BalanceInfo>(16);
            for (Element element : balances) {
                BalanceInfo balanceInfo = new BalanceInfo();
                String bal = JDomUtils.getChildText((Element)element, (String)"bal");
                String selfBal = JDomUtils.getChildText((Element)element, (String)"selfBal");
                String curCode = JDomUtils.getChildText((Element)element, (String)"curCode");
                BalanceUtil.setBankAcnt((BalanceInfo)balanceInfo, (BankAcnt)rqst.getAcnt());
                if (StringUtils.isNotEmpty((String)curCode)) {
                    BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)curCode);
                } else {
                    BalanceUtil.setBankCurrency((BalanceInfo)balanceInfo, (String)rqst.getBankCurrency());
                }
                BalanceUtil.setBalanceDateTime((BalanceInfo)balanceInfo, (LocalDateTime)LocalDateTime.now());
                BalanceUtil.setCurrentBalance((BalanceInfo)balanceInfo, (String)bal);
                BalanceUtil.setAvailableBalance((BalanceInfo)balanceInfo, (String)selfBal);
                balanceInfos.add(balanceInfo);
            }
            EBBankBalanceResponse balanceResponse = new EBBankBalanceResponse();
            balanceResponse.setBalances(balanceInfos);
            return balanceResponse;
        }
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse response = Parser.parseResponse(root);
        ParserUtils.checkRspCode((BankAcnt)rqst.getAcnt(), (String)ResManager.loadKDString((String)"\u4f59\u989d\u67e5\u8be2", (String)"TodayBalanceParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (BankResponse)response, (String)"0");
        Element xDataBody = root.getChild("xDataBody");
        Element balList = xDataBody.getChild("balList");
        List list = balList.getChildren();
        if (list.size() == 0) {
            return new EBBankBalanceResponse();
        }
        ArrayList<BalanceInfo> arraylist = new ArrayList<BalanceInfo>(1);
        String currency = rqst.getBankCurrency();
        for (Object o : list) {
            Element balInfo = (Element)o;
            BalanceInfo balanceinfo = TodayBalanceParser.parseCurBalanceNew(balInfo, currency);
            if (balanceinfo == null) continue;
            arraylist.add(balanceinfo);
        }
        return new EBBankBalanceResponse(arraylist);
    }

    public static BalanceInfo parseCurBalanceNew(Element balInfo, String bankCurrency) throws EBServiceException {
        String state = balInfo.getChildTextTrim("state");
        if (!"1".equalsIgnoreCase(state)) {
            String errCode = balInfo.getChildTextTrim("errCode");
            String errMsg = balInfo.getChildTextTrim("errMsg");
            log.info("\u67e5\u8be2\u4f59\u989d\u5931\u8d25:" + errCode + "," + errMsg);
            throw new EBServiceException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25:%1$s\uff0c%2$s\u3002", (String)"TodayBalanceParser_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), errCode, errMsg));
        }
        log.info("\u67e5\u8be2\u4f59\u989d\u6210\u529f.");
        String acntNo = JDomUtils.getChildText((Element)balInfo, (String)"acntNo");
        String acntName = JDomUtils.getChildText((Element)balInfo, (String)"acntName");
        String acctBal = JDomUtils.getChildText((Element)balInfo, (String)"acctBal");
        String avlBal = JDomUtils.getChildText((Element)balInfo, (String)"avlBal");
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u8d26\u53f7:" + acntNo);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u6237\u540d:" + acntName);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u5f53\u524d\u4f59\u989d:" + acctBal);
        log.info("\u67e5\u8be2\u4f59\u989d\u8fd4\u56de\u53ef\u7528\u4f59\u989d:" + avlBal);
        BankAcnt bankacnt = new BankAcnt();
        bankacnt.setAccNo(acntNo);
        bankacnt.setAccName(acntName);
        BalanceInfo balanceinfo = new BalanceInfo();
        BalanceUtil.setBankAcnt((BalanceInfo)balanceinfo, (BankAcnt)bankacnt);
        BalanceUtil.setBalanceDateTime((BalanceInfo)balanceinfo, (LocalDateTime)LocalDateTime.now());
        BalanceUtil.setBankCurrency((BalanceInfo)balanceinfo, (String)bankCurrency);
        BalanceUtil.setCurrentBalance((BalanceInfo)balanceinfo, (String)acctBal);
        BalanceUtil.setAvailableBalance((BalanceInfo)balanceinfo, (String)avlBal);
        return balanceinfo;
    }
}

