/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.detail;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.detail.NewDetailPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.detail.NewDetailPage;
import kd.ebg.aqap.banks.cmbc.dc.services.detail.NewDetailParser;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.IConnection;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    public boolean match(BankDetailRequest request) {
        return BankBusinessConfig.isVirtualAccount(request.getAcnt().getAccNo()) || "detailLoad".equalsIgnoreCase(BankBusinessConfig.getDetailInterface());
    }

    public String getDeveloper() {
        return "jiashu_xie";
    }

    public String getBizCode() {
        return "B2EVirtualTransDetailQryNew,detailLoad";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6c11\u751f\u94f6\u884c\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        try {
            NewDetailPage page = new NewDetailPage();
            String pageTag = page.getFirstPageTag();
            String rspStr = null;
            do {
                String rqstStr = NewDetailPacker.packTodayDetail(rqst, pageTag);
                super.setDetailImpl();
                ConnectionFactory factory = this.getConnectionFactory();
                IConnection conn = this.getConnection(factory);
                this.openConnection(conn);
                try (OutputStream os = this.getOutputStream(conn);){
                    this.send(os, rqstStr);
                    try (InputStream is = this.getInputStream(conn);){
                        rspStr = this.recv(is);
                        this.closeOutputStreamQuietly(os);
                        this.closeInputStreamQuietly(is);
                        detailList.addAll(NewDetailParser.parseTodayDetail(rqst, rspStr));
                        pageTag = NewDetailPage.getNextPageTag(rspStr, pageTag);
                    }
                }
            } while (!NewDetailPage.isLastPage(rspStr, pageTag));
            return new EBBankDetailResponse(detailList);
        }
        catch (Exception e) {
            throw new EBServiceException((Throwable)e);
        }
    }

    public String pack(BankDetailRequest request) {
        return null;
    }

    public EBBankDetailResponse parse(BankDetailRequest request, String responseStr) {
        return null;
    }
}

