/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.detail.newimpl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.DateHelper;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.banks.cmbc.dc.services.detail.NewDetailPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.detail.NewDetailPage;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.core.utils.BizNoUtil;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.framework.utils.PackerUtils;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class NewDetailImpl
extends AbstractDetailImpl
implements IHisDetail,
IDetail {
    private EBGLogger log = EBGLogger.getInstance().getLogger(NewDetailImpl.class);
    private static int rowNum = 20;

    public String pack(BankDetailRequest bankDetailRequest) {
        String currentPage = this.getCurrentPage();
        String page = currentPage.equalsIgnoreCase("0") ? "1" : currentPage;
        return NewDetailPacker.trsDtlDownLoadPacker(bankDetailRequest, page);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        void var7_9;
        String currentPage = this.getCurrentPage();
        String page = currentPage.equalsIgnoreCase("0") ? "1" : currentPage;
        String nextPageTag = NewDetailPage.getNextPageTag(s, page);
        this.setCurrentPage(nextPageTag);
        boolean lastPage = NewDetailPage.isLastPage(s, nextPageTag);
        this.setLastPage(lastPage);
        ArrayList arrayList = new ArrayList(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)s, (String)encoding);
        BankResponse bankResponse = Parser.parseResponse(root);
        if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
            if ("E4014".equalsIgnoreCase(bankResponse.getResponseCode()) && PropertiesConstants.getValue((String)"ERROR_NOT_RECORD").equalsIgnoreCase(bankResponse.getResponseMessage())) {
                this.log.info("\u67e5\u8be2\u6b64\u65e5\u671f\u671f\u95f4\u65e0\u660e\u7ec6\u6216\u94f6\u884c\u8fd4\u56de\u9519\u8bef\u3002");
                return new EBBankDetailResponse((List)var7_9);
            }
            if ("E6002".equalsIgnoreCase(bankResponse.getResponseCode())) {
                bankResponse.setResponseMessage(String.format(ResManager.loadKDString((String)"%s\u7531\u4e8e\u94f6\u884c\u63a5\u53e3\u9650\u5236\u5982\u679c\u67e5\u8be2\u65e5\u671f\u5305\u542b\u5f53\u65e5\u548c\u5386\u53f2\u65e5\u671f\u65f6\u95f4\u6bb5\u5219\u62a5\u9519\u30021.\u8bf7\u67e5\u8be2\u65f6\u53ea\u9009\u62e9\u5386\u53f2\u65f6\u95f4\u6bb5\u6216\u4ec5\u5f53\u65e5\u65f6\u95f4\u8fdb\u884c\u67e5\u8be2\u30022.\u95f4\u969410\u5206\u949f\u540e\u518d\u6b21\u67e5\u8be2\u3002", (String)"NewDetailParser_5", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), bankResponse.getResponseMessage()));
            }
            EBServiceException ex = new EBServiceException(String.format(ResManager.loadKDString((String)"\u672c\u6b21\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6\u5931\u8d25, \u5f02\u5e38\u4fe1\u606f\u4e3a:%1$s,%2$s", (String)"NewDetailParser_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), bankResponse.getResponseCode(), bankResponse.getResponseMessage()));
            this.log.error(ex.getMessage());
            throw ex;
        }
        Element xdatabody = root.getChild("xDataBody");
        String totalnum = ParserUtils.checkUnNullableElement((Element)xdatabody, (String)"totalNum");
        String dataStr = JDomUtils.getChildText((Element)xdatabody, (String)"dataStream");
        if (null == totalnum) return new EBBankDetailResponse((List)Lists.newArrayList());
        if ("".equalsIgnoreCase(totalnum)) return new EBBankDetailResponse((List)Lists.newArrayList());
        if ("".equalsIgnoreCase(dataStr)) {
            return new EBBankDetailResponse((List)Lists.newArrayList());
        }
        List<DetailInfo> list = this.parseDataString(bankDetailRequest, StringUtils.split((String)dataStr, (String)"|"));
        return new EBBankDetailResponse((List)var7_9);
    }

    private List<DetailInfo> parseDataString(BankDetailRequest rqst, String[] datas) {
        ArrayList<DetailInfo> results = new ArrayList<DetailInfo>(16);
        int i = 0;
        if (datas[0].contains(PropertiesConstants.getValue((String)"DEAL"))) {
            i = 1;
        }
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        while (i < datas.length / rowNum) {
            DetailInfo detailInfo = new DetailInfo();
            detailInfo.setAccNo(rqst.getAcnt().getAccNo());
            detailInfo.setAccName(rqst.getAcnt().getAccName());
            detailInfo.setCurrency(rqst.getBankCurrency());
            detailInfo.setBalance(new BigDecimal(datas[rowNum * i + 7]));
            detailInfo.setDebitAmount(new BigDecimal(datas[rowNum * i + 5]));
            detailInfo.setCreditAmount(new BigDecimal(datas[rowNum * i + 6]));
            String explanation = datas[i * rowNum + 10];
            detailInfo.setExplanation(explanation);
            String timeFormat = "yyyyMMddHHmmss";
            detailInfo.setOppAccNo(datas[i * rowNum + 13]);
            detailInfo.setOppAccName(datas[i * rowNum + 14]);
            detailInfo.setOppBankName(datas[i * rowNum + 15]);
            LocalDateTime parseLocalDateTime = DateHelper.parse(datas[i * rowNum + 19].trim().split("\\.")[0], timeFormat);
            String transDateStr = datas[i * rowNum + 19].substring(0, 8);
            detailInfo.setTransTime(parseLocalDateTime);
            detailInfo.setTransDate(parseLocalDateTime.toLocalDate());
            String cdFlag = "1";
            String amount = "";
            String accNo = rqst.getAcnt().getAccNo();
            if (detailInfo.getDebitAmount().equals(PackerUtils.ZERO)) {
                cdFlag = "1";
                amount = detailInfo.getCreditAmount().toString();
            } else {
                cdFlag = "0";
                amount = detailInfo.getDebitAmount().toString();
            }
            String flowNo = datas[i * rowNum + 1];
            flowNo = flowNo.substring(0, flowNo.length() - 9);
            String bankDetailNo = datas[i * rowNum + 1];
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)bankDetailNo);
            jsonObject.put("cdFlag", (Object)cdFlag);
            jsonObject.put("Amount", (Object)amount);
            jsonObject.put("transDate", (Object)transDateStr);
            jsonObject.put("bankDetailNo", (Object)bankDetailNo);
            jsonObject.put("debitAmount", (Object)detailInfo.getDebitAmount());
            jsonObject.put("creditAmount", (Object)detailInfo.getCreditAmount());
            jsonObject.put("accNo", (Object)rqst.getAcnt().getAccNo());
            detailInfo.setJsonMap(jsonObject.toJSONString());
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDateStr, jsonObject.toJSONString());
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detailInfo.setReceiptNo(receiptNo);
            DetailSysFiled.set((DetailInfo)detailInfo, (String)"bizRefNo", (String)datas[rowNum * i + 1]);
            detailInfo.setBankDetailNo(bankDetailNo);
            results.add(detailInfo);
            if (detailInfo.getCreditAmount().compareTo(PackerUtils.ZERO) == 0 && explanation.contains("_KD_")) {
                String KDRetFlag = BizNoUtil.getId((String)explanation);
                if (KDRetFlag.length() > 8) {
                    KDRetFlag = KDRetFlag.substring(KDRetFlag.length() - 8);
                }
                detailInfo.setPayBankDetailSeqID(KDRetFlag);
                String exp = BizNoUtil.getMsg((String)explanation);
                detailInfo.setExplanation(exp);
            }
            ++i;
        }
        return results;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "trsDtlDownLoad";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankDetailRequest request) {
        return "trsDtlDownLoad".equalsIgnoreCase(BankBusinessConfig.getDetailInterface());
    }

    public boolean isSupportPage() {
        return true;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }
}

