/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.services.Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.framework.utils.ParserUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentParser {
    public static void parsePay(PaymentInfo paymentInfo, String rspStr) throws EBServiceException {
        try {
            String encoding = RequestContextUtils.getCharset();
            Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
            BankResponse bankResponse = Parser.parseResponse(root);
            if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
                if ("W3076".equalsIgnoreCase(bankResponse.getResponseCode()) || "validation.usage.for.transfer.error".equalsIgnoreCase(bankResponse.getResponseCode()) || "10109".equalsIgnoreCase(bankResponse.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                } else if ("Validaation.check.TransTime".equalsIgnoreCase(bankResponse.getResponseCode()) && bankResponse.getResponseMessage().indexOf("Error") != -1) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentParser_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                }
            } else {
                EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5df2\u63a5\u6536", (String)"PaymentParser_2", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%S\u3002", (String)"PaymentParser_8", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
    }

    public static void parseQueryPay(PaymentInfo paymentInfo, String rspStr) throws EBServiceException {
        try {
            String encoding = RequestContextUtils.getCharset();
            Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
            BankResponse bankResponse = Parser.parseResponse(root);
            if (!"0".equalsIgnoreCase(bankResponse.getResponseCode())) {
                if ("E1602".equalsIgnoreCase(bankResponse.getResponseCode())) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)"", (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                } else {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"PaymentParser_1", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
                }
            } else {
                Element xDataBody = root.getChild("xDataBody");
                Element statusId = xDataBody.getChild("statusId");
                if (null == statusId) {
                    EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684statusId\u8282\u70b9\u4e3a\u7a7a\u3002", (String)"PaymentParser_4", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)"", (String)"");
                } else {
                    String statusErrMsg;
                    String statusCode = ParserUtils.checkUnNullableElement((Element)statusId, (String)"statusCode");
                    String statusSeverity = ParserUtils.checkUnNullableElement((Element)statusId, (String)"statusSeverity");
                    String msg = statusErrMsg = ParserUtils.checkUnNullableElement((Element)statusId, (String)"statusErrMsg");
                    if (!StringUtils.isEmpty((String)statusSeverity)) {
                        msg = statusSeverity + statusErrMsg;
                    }
                    paymentInfo.setBankMsg(msg);
                    paymentInfo.setBankStatus(statusCode);
                    if ("0".equalsIgnoreCase(statusCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"PaymentParser_5", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)statusCode, (String)msg);
                    } else if ("2".equalsIgnoreCase(statusCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentParser_0", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)statusCode, (String)msg);
                    } else if ("4".equalsIgnoreCase(statusCode)) {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"PaymentParser_6", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)statusCode, (String)msg);
                    } else {
                        EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentParser_7", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), (String)statusCode, (String)msg);
                    }
                }
            }
        }
        catch (Exception e) {
            EBGBusinessUtils.setPaymentState((PaymentInfo)paymentInfo, (PaymentState)PaymentState.UNKNOWN, (String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5:%s\u3002", (String)"PaymentParser_9", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]), e.getMessage()), (String)"", (String)"");
        }
    }
}

