/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.link;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.AcntHelp;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.link.PayPacker;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.link.PayParser;
import kd.ebg.aqap.banks.cmbc.dc.services.payment.link.QueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.INativeLinkPayable;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;

public class PaymentImpl
extends AbstractPayImpl
implements INativeLinkPayable {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPayImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        return PayPacker.packPay(bankPayRequest.getPaymentInfoAsArray());
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String response) {
        return PayParser.parsePay(bankPayRequest.getPaymentInfoAsArray(), response);
    }

    public String getDeveloper() {
        return "hhm";
    }

    public String getBizCode() {
        return "topXfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u8054\u52a8\u652f\u4ed8", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-cmbc-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        if ("pay_for_linkpay".equalsIgnoreCase(paymentInfo.getSubBizType()) && BankBusinessConfig.islinkpayToCompanyPay()) {
            AcntHelp.checkAccCity(paymentInfo);
            return true;
        }
        return false;
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(Packer.getURL());
    }
}

