/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cmbc.dc.services.payment.virtual;

import java.math.BigDecimal;
import kd.ebg.aqap.banks.cmbc.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cmbc.dc.services.Constants;
import kd.ebg.aqap.banks.cmbc.dc.services.Packer;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.constant.PropertiesConstants;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.service.acnt.BankAcntService;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PayPacker
implements Constants {
    public static String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        if (paymentInfos[0].getIncomeAccNo().contains("-")) {
            return PayPacker.packToVirtual(paymentInfos);
        }
        return PayPacker.packToEntity(paymentInfos);
    }

    private static String packToEntity(PaymentInfo[] paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createMessageWithHead("B2EVirtualAcctTransToEntAcct");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfo.getBankBatchSeqId());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"externBank", (String)(paymentInfo.is2SameBank() ? "0" : "1"));
        if (!paymentInfo.is2SameBank()) {
            JDomUtils.addChild((Element)xdataBody, (String)"PayChannel", (String)PayPacker.getLocalFlag4Pay(paymentInfo));
        } else {
            JDomUtils.addChild((Element)xdataBody, (String)"PayChannel", (String)"");
        }
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeAcType", (String)(paymentInfo.is2Individual() ? "1" : "0"));
        JDomUtils.addChild((Element)xdataBody, (String)"BankCode", (String)paymentInfo.getIncomeCnaps());
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeDeptName", (String)paymentInfo.getIncomeBankName());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcAddr");
        JDomUtils.addChild((Element)xdataBody, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)paymentInfo.getUseCn());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String packToVirtual(PaymentInfo[] paymentInfos) throws EBServiceException {
        PaymentInfo paymentInfo = paymentInfos[0];
        Element root = Packer.createMessageWithHead("B2EVirtualAcctTrans");
        Element xdataBody = JDomUtils.addChild((Element)root, (String)"xDataBody");
        JDomUtils.addChild((Element)xdataBody, (String)"trnId", (String)Sequence.genSequence());
        JDomUtils.addChild((Element)xdataBody, (String)"insId", (String)paymentInfo.getBankBatchSeqId());
        String accNoString = paymentInfo.getAccNo();
        String entityNo = accNoString.substring(0, accNoString.length() - 7);
        JDomUtils.addChild((Element)xdataBody, (String)"AcNo", (String)entityNo);
        BankAcnt acnt = BankAcntService.getInstance().selectByAccNo(entityNo);
        JDomUtils.addChild((Element)xdataBody, (String)"AcName", (String)acnt.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"PayerAcName", (String)paymentInfo.getAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
        JDomUtils.addChild((Element)xdataBody, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
        JDomUtils.addChild((Element)xdataBody, (String)"Amount", (String)BigDecimalHelper.plain2((BigDecimal)paymentInfo.getAmount()));
        JDomUtils.addChild((Element)xdataBody, (String)"Usage", (String)paymentInfo.getUseCn());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }

    private static String getLocalFlag4Pay(PaymentInfo pay) {
        String payeeCity;
        String payerCity = pay.getAccCity();
        if (PayPacker.isShangHaiCity(payerCity, payeeCity = pay.getIncomeCity()) && pay.is2SameCity()) {
            return "4";
        }
        BigDecimal amount = pay.getAmount().setScale(2, 4);
        if (BankBusinessConfig.isCyberFlag()) {
            return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "3" : "1";
        }
        return amount.compareTo(new BigDecimal("1000000.00")) < 0 ? "2" : "1";
    }

    private static boolean isShangHaiCity(String payerCity, String payeeCity) {
        return payerCity.contains(PropertiesConstants.getValue((String)"SHANGHAI")) || payeeCity.contains(PropertiesConstants.getValue((String)"SHANGHAI"));
    }
}

