/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsbl.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsbl.dc.HsblMetaDataImpl;
import kd.ebg.aqap.banks.hsbl.dc.service.api.HsblPgpHelper;
import kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single.PayPacker;
import kd.ebg.aqap.banks.hsbl.dc.service.api.payment.single.SingleQueryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.HttpsConnection;
import kd.ebg.egf.common.framework.communication.IConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class PaymentImpl
extends AbstractPayImpl {
    private static final EBGLogger LOGGER = EBGLogger.getInstance().getLogger(PaymentImpl.class);

    public IConnection getConnection(ConnectionFactory factory) {
        HashMap<String, String> httpHeaders = new HashMap<String, String>(16);
        httpHeaders.put("Content-Type", "application/json");
        httpHeaders.put("x-hsbc-client-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientId));
        httpHeaders.put("x-hsbc-client-secret", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.clientSecret));
        httpHeaders.put("x-hsbc-profile-id", RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.profileId));
        httpHeaders.put("x-payload-type", "pain.001.001.03");
        String ip = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiIP);
        String port = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiPort);
        String protocol = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.apiProtocol);
        String uri = RequestContextUtils.getBankParameterValue((String)HsblMetaDataImpl.singlePayURI);
        String timeOut = RequestContextUtils.getBankParameterValue((String)"timeout");
        if ("http".equalsIgnoreCase(protocol)) {
            return new HttpConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        if ("tcp".equalsIgnoreCase(protocol)) {
            return new TcpConnection(ip, Integer.parseInt(port), Integer.parseInt(timeOut));
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return new HttpsConnection(ip, Integer.parseInt(port), uri, httpHeaders, Integer.parseInt(timeOut));
        }
        throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5176\u4ed6\u901a\u8baf\u534f\u8bae\u3002", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]));
    }

    public String getDeveloper() {
        return "guoqiangyao";
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5355\u7b14\u652f\u4ed8", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]);
    }

    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return SingleQueryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        String bankMsg = PayPacker.packPayXmlPP(bankPayRequest.getPaymentInfoAsArray());
        try {
            LOGGER.info(ResManager.loadKDString((String)"\u8bf7\u6c42\u7684total\u4fe1\u606f{}\u3002", (String)"PaymentImpl_4", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (Object)bankMsg);
            String base64 = HsblPgpHelper.encry(bankMsg);
            LOGGER.info(ResManager.loadKDString((String)"\u8bf7\u6c42\u5230\u7684base64\u7f16\u53f7{}\u3002", (String)"PaymentImpl_5", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (Object)base64);
            JSONObject request = new JSONObject();
            request.put("paymentBase64", (Object)base64);
            LOGGER.info(ResManager.loadKDString((String)"\u53d1\u9001\u94f6\u884c:", (String)"PaymentImpl_6", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]) + request.toJSONString());
            return request.toJSONString();
        }
        catch (Throwable e) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u7b7e\u540d\u52a0\u5bc6\u65f6\u53d1\u751f\u5f02\u5e38:%s\u3002", (String)"PaymentImpl_14", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        LOGGER.info(ResManager.loadKDString((String)"\u8fd4\u56de\u62a5\u6587\uff1a", (String)"PaymentImpl_7", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]) + s);
        JSONObject payRsp = JSONObject.parseObject((String)s);
        String error = payRsp.getString("error");
        String description = payRsp.getString("description");
        if (!StringUtils.isEmpty((String)error)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)error, (String)description);
        } else {
            String statusCode = payRsp.getString("statusCode");
            String statusDesc = payRsp.getString("statusDesc");
            if ("RJCT".equals(statusCode)) {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"PaymentImpl_8", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (String)statusCode, (String)statusDesc);
            } else {
                String referenceId = payRsp.getString("referenceId");
                LOGGER.info(ResManager.loadKDString((String)"\u8be5\u7b14\u4ed8\u6b3e\u7ed1\u5b9a\u7684ReferenceId\u4e3a", (String)"PaymentImpl_9", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), (Object)referenceId);
                PaymentInfoSysFiled.set((List)paymentInfos, (String)"hsbl_referenceId", (String)referenceId);
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)statusCode, (String)statusDesc);
            }
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "API".equalsIgnoreCase(BankBusinessConfig.getBorderPay()) && paymentInfo.getTotalCount() == 1;
    }
}

