/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.pp;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ksql.util.Base64;
import kd.ebg.aqap.banks.hsbl.dc.service.HSBL_DC_Packer;
import kd.ebg.aqap.banks.hsbl.dc.service.payment.oversea.HSBL_DC_CommonPacker;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.Helper;
import kd.ebg.aqap.banks.hsbl.dc.service.utils.TransactionRemarksUtils;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.ISOCountryUtils;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.CountryISOCode;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class PayPacker {
    public String packPay(PaymentInfo[] paymentInfos) throws EBServiceException {
        Element simulator = new Element("simulator");
        Element head = HSBL_DC_Packer.createHead("XML");
        JDomUtils.addChild((Element)simulator, (Element)head);
        Element body = JDomUtils.addChild((Element)simulator, (String)"body");
        Element reqPara = JDomUtils.addChild((Element)body, (String)"reqPara");
        JDomUtils.addChild((Element)reqPara, (String)"uploadMethod", (String)"ftp");
        String bankMsg = Base64.encodeString((String)this.packPayXmlPP(paymentInfos));
        JDomUtils.addChild((Element)body, (String)"bankMsg", (String)bankMsg);
        return JDomUtils.root2String((Element)simulator, (String)RequestContextUtils.getCharset());
    }

    public String packPayXmlPP(PaymentInfo[] paymentInfos) throws EBServiceException {
        Namespace ns1 = Namespace.getNamespace((String)"", (String)"urn:iso:std:iso:20022:tech:xsd:pain.001.001.03");
        Namespace ns2 = Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance");
        Element root = JDomUtils.createRoot((String)"Document");
        root.setNamespace(ns1);
        root.addNamespaceDeclaration(ns2);
        Element CstmrCdtTrfInitn = JDomUtils.addChild((Element)root, (String)"CstmrCdtTrfInitn").setNamespace(ns1);
        Element GrpHdr = HSBL_DC_CommonPacker.packPayXmlhead(paymentInfos, CstmrCdtTrfInitn);
        Element PmtInf = HSBL_DC_CommonPacker.packPayXmlPmtInfo(paymentInfos, CstmrCdtTrfInitn);
        BigDecimal totalAmount = new BigDecimal("0.00");
        for (PaymentInfo item : paymentInfos) {
            Element CdtTrfTxInf = JDomUtils.addChild((Element)PmtInf, (String)"CdtTrfTxInf").setNamespace(ns1);
            Element PmtId = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"PmtId").setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"InstrId", (String)item.getBankDetailSeqId()).setNamespace(ns1);
            JDomUtils.addChild((Element)PmtId, (String)"EndToEndId", (String)item.getBankDetailSeqId()).setNamespace(ns1);
            Element Amt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Amt").setNamespace(ns1);
            Element InstdAmt = JDomUtils.addChild((Element)Amt, (String)"InstdAmt", (String)item.getActualAmount().toString()).setNamespace(ns1);
            totalAmount = totalAmount.add(item.getActualAmount());
            InstdAmt.setAttribute("Ccy", item.getPayCurrency());
            if (item.getPayerFeeType().equalsIgnoreCase("01")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"DEBT").setNamespace(ns1);
            } else if (item.getPayerFeeType().equalsIgnoreCase("02")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"CRED").setNamespace(ns1);
            } else if (item.getPayerFeeType().equalsIgnoreCase("03")) {
                JDomUtils.addChild((Element)CdtTrfTxInf, (String)"ChrgBr", (String)"SHAR").setNamespace(ns1);
            }
            Element CdtrAgt = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAgt").setNamespace(ns1);
            Element CdtrAgt_FinInstnId = JDomUtils.addChild((Element)CdtrAgt, (String)"FinInstnId").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"BIC", (String)item.getIncomeSwiftCode()).setNamespace(ns1);
            if (!StringUtils.isEmpty((String)item.getIncomeBankLocalClearingCode())) {
                Element ClrSysMmbId = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"ClrSysMmbId").setNamespace(ns1);
                JDomUtils.addChild((Element)ClrSysMmbId, (String)"MmbId", (String)item.getIncomeBankLocalClearingCode()).setNamespace(ns1);
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"Nm", (String)item.getIncomeBankName()).setNamespace(ns1);
            Element CdtrAgt_FinInstnId_PstlAdr = JDomUtils.addChild((Element)CdtrAgt_FinInstnId, (String)"PstlAdr").setNamespace(ns1);
            String benefitBankAddress = item.getIncomeBankAddress();
            Helper.addressSplit(CdtrAgt_FinInstnId_PstlAdr, benefitBankAddress);
            CountryISOCode code = ISOCountryUtils.getInstance().getCountryInfo(item.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%s\u3002", (String)"PayPacker_3", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), item.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)CdtrAgt_FinInstnId_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element Cdtr = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"Cdtr").setNamespace(ns1);
            JDomUtils.addChild((Element)Cdtr, (String)"Nm", (String)Helper.formatStringByLength(item.getIncomeAccName(), 70)).setNamespace(ns1);
            Element Cdtr_PstlAdr = JDomUtils.addChild((Element)Cdtr, (String)"PstlAdr").setNamespace(ns1);
            Helper.addressSplit(Cdtr_PstlAdr, item.getIncomeAddress());
            code = ISOCountryUtils.getInstance().getCountryInfo(item.getIncomeCountry());
            if (null == code) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u65b9\u56fd\u5bb6\uff1a%s\u683c\u5f0f\u4e0d\u5bf9\uff0c\u6216\u672a\u80fd\u4ece\u56fd\u5bb6\u4ee3\u7801\u8868\u4e2d\u5339\u914d\u3002", (String)"PayPacker_2", (String)"ebg-aqap-banks-hsbl-dc", (Object[])new Object[0]), item.getIncomeCountry()));
            }
            JDomUtils.addChild((Element)Cdtr_PstlAdr, (String)"Ctry", (String)code.geteChart2()).setNamespace(ns1);
            Element CdtrAcct = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"CdtrAcct").setNamespace(ns1);
            Element CdtrAcct_Id = JDomUtils.addChild((Element)CdtrAcct, (String)"Id").setNamespace(ns1);
            Element CdtrAcct_Id_Othr = JDomUtils.addChild((Element)CdtrAcct_Id, (String)"Othr").setNamespace(ns1);
            JDomUtils.addChild((Element)CdtrAcct_Id_Othr, (String)"Id", (String)item.getIncomeAccNo()).setNamespace(ns1);
            if (!StringUtils.isEmpty((String)item.getTransactionRemarks())) {
                Element RgltryRptg = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RgltryRptg").setNamespace(ns1);
                Element Dtls = JDomUtils.addChild((Element)RgltryRptg, (String)"Dtls").setNamespace(ns1);
                String Inf = TransactionRemarksUtils.getInstance().getTransactionRemark(item.getTransactionRemarks(), item.getBankVersionID());
                JDomUtils.addChild((Element)Dtls, (String)"Inf", (String)Inf).setNamespace(ns1);
            }
            if (StringUtils.isEmpty((String)item.getExplanation())) continue;
            Element RmtInf = JDomUtils.addChild((Element)CdtTrfTxInf, (String)"RmtInf").setNamespace(ns1);
            JDomUtils.addChild((Element)RmtInf, (String)"Ustrd", (String)item.getExplanation()).setNamespace(ns1);
        }
        Element CtrlSum = GrpHdr.getChild("CtrlSum", ns1);
        CtrlSum.addContent(totalAmount.toString());
        return JDomUtils.root2String((Element)root, (String)RequestContextUtils.getCharset());
    }
}

