/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance.balanceCheck;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceReconciliationImpl;
import kd.ebg.aqap.business.balancereconciliation.atomic.IBalanceReconciliation;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceReconciliationRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceReconciliationResponse;
import kd.ebg.aqap.business.balancereconciliation.utils.BalanceReconciliationState;
import kd.ebg.aqap.business.balancereconciliation.utils.ReconciliationBusinessUtil;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class BalanceReconciliationImpl
extends AbstractBalanceReconciliationImpl
implements IBalanceReconciliation {
    public String pack(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        String checkDate = detail.getBiz("checkDate");
        String checkStatus = detail.getCheckStatus();
        if ("N".equals(checkStatus)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u6682\u65f6\u4e0d\u652f\u6301\u4e0d\u76f8\u7b26\u5bf9\u8d26", (String)"BalanceReconciliationImpl_3", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        Element body = new Element("body");
        String accNo = detail.getAccNo();
        if (StringUtils.isEmpty((String)checkDate)) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u8d26\u5355\u8d26\u671f\u4e3a\u7a7a\u65e0\u6cd5\u8fdb\u884c\u5bf9\u8d26\u53cd\u9988", (String)"BalanceReconciliationImpl_2", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]));
        }
        JDomUtils.addChild((Element)body, (String)"checkDate", (String)checkDate);
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"isSame", (String)"1");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("ER43", signedMsg);
    }

    public EBBankBalanceReconciliationResponse parse(BankBalanceReconciliationRequest bankBalanceReconciliationRequest, String responseStr) {
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u53cd\u9988\u5f02\u5e38 :%s\u3002", (String)"BalanceReconciliationImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        BalanceReconciliationDetail detail = bankBalanceReconciliationRequest.getDetail();
        String dealStatus = body.getChildText("dealStatus");
        int status = Integer.parseInt(dealStatus);
        if (status >= 0) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.SUCCESS, (String)dealStatus, (String)BalanceReconciliationState.SUCCESS.getCnName());
        } else if (status == -1) {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.FAIL, (String)dealStatus, (String)BalanceReconciliationState.FAIL.getCnName());
        } else {
            ReconciliationBusinessUtil.setBalanceReconciliationState((BalanceReconciliationDetail)detail, (BalanceReconciliationState)BalanceReconciliationState.UNKNOWN, (String)dealStatus, (String)BalanceReconciliationState.UNKNOWN.getCnName());
        }
        return new EBBankBalanceReconciliationResponse(detail);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "ER43";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u53cd\u9988", (String)"BalanceReconciliationImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceReconciliationRequest bankBalanceReconciliationRequest) {
        return true;
    }
}

