/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.spdb.dc.services.balance.balanceCheck;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.spdb.dc.services.Check;
import kd.ebg.aqap.banks.spdb.dc.services.Packer;
import kd.ebg.aqap.banks.spdb.dc.services.ParserRsp;
import kd.ebg.aqap.banks.spdb.dc.services.Signature;
import kd.ebg.aqap.business.balancereconciliation.atomic.AbstractBalanceStatementImpl;
import kd.ebg.aqap.business.balancereconciliation.bank.BankBalanceStatementRequest;
import kd.ebg.aqap.business.balancereconciliation.bank.EBBankBalanceStatementResponse;
import kd.ebg.aqap.common.model.BalanceReconciliationDetail;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QueryBalanceBillImpl
extends AbstractBalanceStatementImpl {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(QueryBalanceBillImpl.class);

    public String pack(BankBalanceStatementRequest bankBalanceStatementRequest) {
        Element body = new Element("body");
        String accNo = bankBalanceStatementRequest.getAccNo();
        JDomUtils.addChild((Element)body, (String)"checkDate", (String)RequestContextUtils.getRunningParam((String)"checkDate"));
        JDomUtils.addChild((Element)body, (String)"acctNo", (String)accNo);
        JDomUtils.addChild((Element)body, (String)"checkStatus", (String)"1");
        JDomUtils.addChild((Element)body, (String)"beginNumber", (String)"1");
        JDomUtils.addChild((Element)body, (String)"queryNumber", (String)"50");
        String srcSign = JDomUtils.root2StringWithoutXMLDeclaration((Element)body, (String)RequestContextUtils.getCharset());
        log.info("\u7b7e\u540d\u524d\u62a5\u6587==" + srcSign);
        Signature sign = Signature.getInstance();
        String signedMsg = sign.sign(srcSign);
        return Packer.packToReqMsg("FP99", signedMsg);
    }

    public EBBankBalanceStatementResponse parse(BankBalanceStatementRequest bankBalanceStatementRequest, String responseStr) {
        BankResponse rsp = ParserRsp.parseRsp(responseStr);
        if (!"AAAAAAA".equalsIgnoreCase(rsp.getResponseCode())) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u8d26\u5355\u67e5\u8be2\u5931\u8d25 :%s\u3002", (String)"QueryBalanceBillImpl_1", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]), StringUtils.catWithSpace((String[])new String[]{rsp.getResponseCode(), rsp.getResponseMessage()}));
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String rspData = Signature.getInstance().validateSignedData(responseStr);
        Element body = JDomUtils.string2Root((String)rspData, (String)RequestContextUtils.getCharset());
        ArrayList<BalanceReconciliationDetail> detailList = new ArrayList<BalanceReconciliationDetail>(5);
        Element lists = Check.checkNoNullChildElement(body, "lists");
        List localList = lists.getChildren("list");
        BigDecimal balance = new BigDecimal("0.0");
        String currency = "";
        for (Element element : localList) {
            String bankBalance;
            currency = element.getChildText("currency");
            if ("RMB".equals(currency)) {
                currency = "01";
            }
            if (!StringUtils.isNotEmpty((String)(bankBalance = element.getChildText("bankBalance"))) || !currency.equals(bankBalanceStatementRequest.getCurrency())) continue;
            balance = balance.add(new BigDecimal(bankBalance));
        }
        if ("01".equals(currency)) {
            String checkDate = body.getChildText("checkDate");
            BalanceReconciliationDetail detail = new BalanceReconciliationDetail();
            detail.setBalance(balance.toPlainString());
            detail.setAccNo(bankBalanceStatementRequest.getAccNo());
            detail.setMonth(checkDate.substring(0, 6));
            detail.setCurrency(currency);
            detail.setBiz("checkDate", checkDate);
            detailList.add(detail);
            return new EBBankBalanceStatementResponse(detailList);
        }
        log.info("\u672c\u6b21\u4f59\u989d\u5bf9\u8d26\u5355\u67e5\u8be2\u6ca1\u6709\u8fd4\u56de\u4eba\u6c11\u5e01\u8d26\u6237");
        return new EBBankBalanceStatementResponse(detailList);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "FP99";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u4f59\u989d\u5bf9\u8d26\u8d26\u5355\u67e5\u8be2", (String)"QueryBalanceBillImpl_0", (String)"ebg-aqap-banks-spdb-dc", (Object[])new Object[0]);
    }

    public boolean match(BankBalanceStatementRequest bankBalanceStatementRequest) {
        return false;
    }
}

