/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.dc.util;

import kd.ebg.aqap.banks.gdb.dc.BankBusinessConfig;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFieldConstants;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.business.payment.utils.PaymentUtil;
import kd.ebg.aqap.common.model.PaymentInfo;

public final class KDUtil {
    public static final String KD_FLAG = "_KD_";

    public static String getKDStr(PaymentInfo paymentInfo) {
        if (BankBusinessConfig.isAddKDFlagToPay()) {
            PaymentUtil.setKdFlagIDByBankDetailSeqID((PaymentInfo)paymentInfo);
            PaymentInfoSysFiled.set((PaymentInfo)paymentInfo, (String)PaymentInfoSysFieldConstants.BANK_DETAIL_SEQ_ID, (String)paymentInfo.getBankDetailSeqId());
            return paymentInfo.getBankDetailSeqId() + KD_FLAG;
        }
        return "";
    }

    public static String getBankDetailSeqIdFromStr(String kdStr) {
        if (BankBusinessConfig.isAddKDFlagToPay() && kdStr != null && kdStr.length() > 0) {
            int index = kdStr.indexOf(KD_FLAG);
            if (index != -1) {
                return kdStr.substring(0, index);
            }
            return "";
        }
        return "";
    }

    public static String cutKDFlag(String kdStr) {
        int index;
        if (kdStr != null && kdStr.length() > 0 && (index = kdStr.indexOf(KD_FLAG)) != -1) {
            return kdStr.substring(index + KD_FLAG.length());
        }
        return kdStr;
    }
}

