/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.cdb.dc.services.balance;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.cdb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.cdb.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.cdb.dc.utils.TCommon;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IHisBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class HisBalanceImpl
extends AbstractBalanceImpl
implements IHisBalance {
    static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);

    public String pack(BankBalanceRequest request) {
        BankAcnt acnt = request.getAcnt();
        String trCode = "STTQ0103";
        Element Packet = TCommon.createCommonHead(trCode);
        Element Data = Packet.getChild("Data");
        Element Pag = JDomUtils.addChild((Element)Data, (String)"Pag");
        JDomUtils.addChild((Element)Pag, (String)"PgupOrPgdn", (String)"1");
        JDomUtils.addChild((Element)Pag, (String)"TotalNum", (String)"-1");
        JDomUtils.addChild((Element)Pag, (String)"CurrentNum", (String)"0");
        JDomUtils.addChild((Element)Pag, (String)"PageStart", (String)"0");
        JDomUtils.addChild((Element)Pag, (String)"PageEnd", (String)"0");
        Element Req = JDomUtils.addChild((Element)Data, (String)"Req");
        String accNo = acnt.getAccNo();
        JDomUtils.addChild((Element)Req, (String)"BASE_ACCT_NO", (String)BankBusinessConfig.getAcnoType(accNo));
        JDomUtils.addChild((Element)Req, (String)"ACCT_TYPE", (String)"");
        JDomUtils.addChild((Element)Req, (String)"CCY", (String)request.getBankCurrency());
        JDomUtils.addChild((Element)Req, (String)"START_MONTH", (String)"");
        JDomUtils.addChild((Element)Req, (String)"START_YEAR", (String)"");
        JDomUtils.addChild((Element)Req, (String)"START_DATE", (String)request.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Req, (String)"END_DATE", (String)request.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)Req, (String)"CERTIFICATE_NO", (String)"");
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2String((Element)Packet, (String)encoding);
        return xmlMsg;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element Packet = JDomUtils.string2Root((String)responseStr, (String)encoding);
        Element Data = Packet.getChild("Data");
        Element Pub = Data.getChild("Pub");
        BankResponse response = TCommon.parseBankResponse(Pub);
        if (!"000000".equals(response.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1a%1$s\uff0c%2$s\u3002", (String)"HisBalanceImpl_3", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]), response.getResponseCode(), response.getResponseMessage()));
        }
        Element Res = Data.getChild("Res");
        List list = Res.getChildren("BAL_ARRAY");
        if (list == null || list.size() == 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25\uff0c\u539f\u56e0\uff1aBAL_ARRAY\u5143\u7d20\u4e3a\u7a7a\u3002", (String)"HisBalanceImpl_1", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]));
        }
        ArrayList<BalanceInfo> resultList = new ArrayList<BalanceInfo>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Element e = (Element)list.get(i);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(e.getChildTextTrim("TRAN_DATE")).append(e.getChildTextTrim("BAL_DATE"));
            BalanceInfo balanceInfo = new BalanceInfo();
            balanceInfo.setBankAcnt(request.getAcnt());
            balanceInfo.setBankCurrency(request.getBankCurrency());
            balanceInfo.setBalanceDateTime(LocalDateTime.parse(stringBuilder, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            if (!StringUtils.isEmpty((String)e.getChildTextTrim("LEDGER_BAL"))) {
                balanceInfo.setCurrentBalance(new BigDecimal(e.getChildTextTrim("LEDGER_BAL")));
            }
            if (!StringUtils.isEmpty((String)e.getChildTextTrim("CLEARED_BAL"))) {
                // empty if block
            }
            resultList.add(balanceInfo);
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList(resultList));
    }

    public LocalDate limitDate() {
        return null;
    }

    public String getDeveloper() {
        return "kingdee";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5386\u53f2\u4f59\u989d", (String)"HisBalanceImpl_2", (String)"ebg-aqap-banks-cdb-dc", (Object[])new Object[0]);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(TCommon.getHttpUrl("unsign"));
        factory.setHttpHeader("Content-Type", "text/plain");
        factory.setHttpHeader("Accept-Charset", "utf-8");
    }
}

