/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.bochk.dc.services.balance;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.bochk.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_BankBatchSeqIdCreator;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Packer;
import kd.ebg.aqap.banks.bochk.dc.services.BOCHK_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.common.framework.services.MappingAcctService;
import kd.ebg.aqap.common.framework.utils.CurrencyUtils;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.framework.service.properties.ObjectPropertyService;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.bank.BankAcnt;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class RegionBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    private static final EBGLogger log = EBGLogger.getInstance().getLogger(RegionBalanceImpl.class);

    public String pack(BankBalanceRequest bankBalanceRequest) {
        MappingAcctService service = MappingAcctService.getInstance();
        List acnts = bankBalanceRequest.getBankAcntList();
        Element root = BOCHK_DC_Packer.createRootWithHead(BOCHK_DC_BankBatchSeqIdCreator.getPackageId());
        Element Tx = JDomUtils.createRoot((String)"Tx");
        Element RgAcctBalanceREQ = JDomUtils.addChild((Element)Tx, (String)"RgAcctBalanceREQ");
        Element requests = JDomUtils.addChild((Element)RgAcctBalanceREQ, (String)"Requests").setAttribute("noOfRecord", String.valueOf(acnts.size()));
        for (BankAcnt acnt : acnts) {
            Element record = JDomUtils.addChild((Element)requests, (String)"Record");
            String accNo = acnt.getAccNo();
            String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
            accNo = service.mapping(accNo, iso);
            JDomUtils.addChild((Element)record, (String)"AcctNo", (String)accNo);
            String swiftCode = acnt.getSwiftCode();
            String ownSwiftCode = BankBusinessConfig.getBicCode(acnt.getAccNo());
            if (StringUtils.isEmpty((String)swiftCode)) {
                if (StringUtils.isEmpty((String)ownSwiftCode)) {
                    log.info("\u5f53\u524d\u67e5\u8be2\u7684\u8d26\u6237\u7f3a\u5931Swift Code");
                    ownSwiftCode = "";
                }
                swiftCode = ownSwiftCode;
            } else if (StringUtils.isEmpty((String)ownSwiftCode) || !ownSwiftCode.equalsIgnoreCase(swiftCode)) {
                ObjectPropertyService srv = (ObjectPropertyService)SpringContextUtil.getBean(ObjectPropertyService.class);
                srv.saveAcntProperties("BOC_HK_BIC_CODE", swiftCode, acnt.getAccNo());
            }
            JDomUtils.addChild((Element)record, (String)"BicCode", (String)swiftCode);
            JDomUtils.addChild((Element)record, (String)"TransCur", (String)bankBalanceRequest.getBankCurrency());
        }
        JDomUtils.addChild((Element)root, (Element)Tx);
        String encoding = RequestContextUtils.getCharset();
        String requestMessage = JDomUtils.root2String((Element)root, (String)encoding);
        log.info("\u67e5\u8be2\u4f59\u989d\u62a5\u6587\u5982\u4e0b\uff1a" + requestMessage);
        return requestMessage;
    }

    public EBBankBalanceResponse parse(BankBalanceRequest bankBalanceRequest, String s) {
        MappingAcctService service = MappingAcctService.getInstance();
        log.info("==\u67e5\u8be2\u4f59\u989d\u54cd\u5e94\u62a5\u6587\u7684\u89e3\u6790\u2014\u2014\u5f00\u59cb==");
        Element root = JDomUtils.string2Root((String)s, (String)RequestContextUtils.getCharset());
        BankResponse bankRsp = BOCHK_DC_Parser.parseHead(root);
        if (!"S".equals(bankRsp.getResponseCode())) {
            String ErrorCode = root.getChild("Head").getChild("ErrorCode").getTextTrim();
            String ErrorDesc = root.getChild("Head").getChild("ErrorDesc").getTextTrim();
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u4e3a(%1$s,%2$s);\u9519\u8bef\u7801\uff1a%3$s,\u9519\u8bef\u8bf4\u660e\uff1a%4$s", (String)"RegionBalanceImpl_7", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankRsp.getResponseCode(), bankRsp.getResponseMessage(), ErrorCode, ErrorDesc));
        }
        Element RgAcctBalanceRLY = root.getChild("Tx").getChild("RgAcctBalanceRLY");
        List records = RgAcctBalanceRLY.getChild("BalInfo").getChild("Result").getChildren("Record");
        BalanceInfo balanceInfo = null;
        String iso = CurrencyUtils.convert2Iso((String)bankBalanceRequest.getCurrency(), (String)bankBalanceRequest.getHeader().getBankVersionID(), (String)bankBalanceRequest.getHeader().getCustomerID());
        for (int i = 0; i < records.size(); ++i) {
            Element record = (Element)records.get(i);
            String acctNo = record.getChildTextTrim("AcctNo");
            BankAcnt bankAcnt = this.search(bankBalanceRequest.getBankAcntList(), acctNo, iso);
            if (Objects.isNull(bankAcnt)) {
                throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u7ed3\u679c\u672a\u5305\u542b\u5f85\u67e5\u8be2\u7684\u8d26\u6237\u3002", (String)"RegionBalanceImpl_3", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]));
            }
            String avalBal = record.getChildTextTrim("AvalBal");
            String ledBal = record.getChildTextTrim("LedBal");
            String lastUpdateTime = record.getChildTextTrim("LastUpdateTime");
            LocalDateTime balanceTime = this.parseBalanceTime(lastUpdateTime);
            balanceInfo = new BalanceInfo();
            this.setBankAcnt(balanceInfo, bankAcnt);
            this.setAvailableBalance(balanceInfo, avalBal);
            this.setCurrentBalance(balanceInfo, ledBal);
            this.setBalanceDateTime(balanceInfo, balanceTime);
            String mappingAcc = service.mapping(acctNo, iso);
            balanceInfo.setExtraBankAcnt(mappingAcc);
        }
        if (balanceInfo == null) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4f59\u989d\u5931\u8d25\uff0c\u94f6\u884c\u672a\u8fd4\u56de\u8bf7\u6c42\u8d26\u53f7[%1$s]\u6240\u67e5\u8be2\u5e01\u79cd[%2$s]\u7684\u4f59\u989d\u4fe1\u606f\u3002", (String)"RegionBalanceImpl_8", (String)"ebg-aqap-banks-bochk-dc", (Object[])new Object[0]), bankBalanceRequest.getAcnt().getAccNo(), bankBalanceRequest.getBankCurrency()));
        }
        return new EBBankBalanceResponse((List)Lists.newArrayList((Object[])new BalanceInfo[]{balanceInfo}));
    }

    private LocalDateTime parseBalanceTime(String LastUpdateTime) {
        LocalDateTime balanceTime;
        String back_up = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE) + "000000";
        try {
            balanceTime = LocalDateTime.parse(LastUpdateTime, DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm z"));
        }
        catch (Exception e) {
            return LocalDateTime.parse(back_up, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        }
        return balanceTime;
    }

    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory factory = super.getConnectionFactory();
        factory.setUri(RequestContextUtils.getBankParameterValue((String)"bankUrl"));
        factory.setHttpHeader("Content-Type", "application/xml;charset=" + RequestContextUtils.getCharset());
        return factory;
    }

    public BankAcnt search(List<BankAcnt> bankAcnts, String accNo, String iso) {
        MappingAcctService service = MappingAcctService.getInstance();
        for (BankAcnt bankAcnt : bankAcnts) {
            if (!accNo.equalsIgnoreCase(service.mapping(bankAcnt.getAccNo(), iso))) continue;
            return bankAcnt;
        }
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "RgAcctBalanceREQ";
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(BankBalanceRequest request) {
        return BankBusinessConfig.getBOC_HK_OTHER_OR_SELF_QRY();
    }
}

