/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.szns.dc.services.payment.otherbank;

import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.szns.dc.services.payment.Packer;
import kd.ebg.aqap.banks.szns.dc.services.payment.Parser;
import kd.ebg.aqap.banks.szns.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.sdk.ebg.trd.exception.SDKException;
import kd.sdk.ebg.trd.jdom.SDKElement;
import kd.sdk.ebg.trd.jdom.SDKElementUtil;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 1;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QryPaymentImpl.class;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        SDKElement root = null;
        try {
            root = Packer.buildHead("B2ECrossBankTransfer", paymentInfo.getBankBatchSeqId());
            SDKElement Map2 = SDKElementUtil.getChild((SDKElement)root, (String)"Body").getChild("List").getChild("Map");
            SDKElementUtil.addChild((SDKElement)Map2, (String)"PayerAcNo", (String)paymentInfo.getAccNo());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"Currency", (String)paymentInfo.getCurrency());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"PayeeAcNo", (String)paymentInfo.getIncomeAccNo());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"PayeeAcName", (String)paymentInfo.getIncomeAccName());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"Amount", (String)paymentInfo.getAmount().toString());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"UnionDeptId", (String)paymentInfo.getIncomeBankLocalClearingCode());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"PayeeBankName", (String)paymentInfo.getIncomeBankName());
            SDKElementUtil.addChild((SDKElement)Map2, (String)"PayPathCode", (String)"1002");
            SDKElementUtil.addChild((SDKElement)Map2, (String)"Priority", (String)"0");
            if (StringUtils.isNotEmpty((String)paymentInfo.getExplanation())) {
                String remark = paymentInfo.getExplanation();
                remark = remark.length() > 40 ? remark.substring(0, 40) : remark;
                SDKElementUtil.addChild((SDKElement)Map2, (String)"Remark", (String)remark);
            } else {
                SDKElementUtil.addChild((SDKElement)Map2, (String)"Remark", (String)"");
            }
            return SDKElementUtil.root2String((SDKElement)root, (String)RequestContextUtils.getCharset());
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String rspStr) {
        try {
            SDKElement root = SDKElementUtil.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
            BankResponse bankResponse = Parser.parseHeader(root);
            List paymentInfos = bankPayRequest.getPaymentInfos();
            if ("000000".equals(bankResponse.getResponseCode())) {
                SDKElement list = SDKElementUtil.getChild((SDKElement)root, (String)"Body").getChild("List");
                SDKElement map = list.getChild("Map");
                String status = SDKElementUtil.getChildTextTrim((SDKElement)map, (String)"ReturnCode");
                String returnMsg = SDKElementUtil.getChildTextTrim((SDKElement)map, (String)"ReturnMsg");
                if ("00".equals(status) || "01".equals(status) || "02".equals(status) || "03".equals(status)) {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u63d0\u4ea4\u94f6\u884c\u6210\u529f", (String)"PaymentImpl_0", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
                } else {
                    EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4\u3002", (String)"PaymentImpl_1", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)status, (String)returnMsg);
                }
            } else {
                EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u672a\u786e\u8ba4", (String)"PaymentImpl_2", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]), (String)bankResponse.getResponseCode(), (String)bankResponse.getResponseMessage());
            }
            return new EBBankPayResponse(paymentInfos);
        }
        catch (SDKException e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public String getDeveloper() {
        return "simon";
    }

    public String getBizCode() {
        return "B2ECrossBankTransfer";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u94f6\u4f01\u76f4\u8054\u8de8\u884c\u8f6c\u8d26", (String)"PaymentImpl_3", (String)"ebg-aqap-banks-szns-dc", (Object[])new Object[0]);
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay".equalsIgnoreCase(paymentInfo.getSubBizType()) && !paymentInfo.is2SameBank() && "CNY".equals(paymentInfo.getIsoCurrencyCode());
    }

    public void configFactory(ConnectionFactory factory) {
        String s = "/eweb/" + this.getBizCode() + ".do?userPassword=";
        s = s + RequestContextUtils.getParameter().getBankParameter("OpNo") + "&SIGDATA=1";
        factory.setUri(s);
        super.configFactory(factory);
    }
}

