/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.balance;

import java.io.InputStream;
import java.time.LocalDateTime;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Packer;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.business.balance.atomic.AbstractBalanceImpl;
import kd.ebg.aqap.business.balance.atomic.IBalance;
import kd.ebg.aqap.business.balance.bank.BalanceInfo;
import kd.ebg.aqap.business.balance.bank.BankBalanceRequest;
import kd.ebg.aqap.business.balance.bank.EBBankBalanceResponse;
import kd.ebg.aqap.business.util.ShowTipUtil;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class TodayBalanceImpl
extends AbstractBalanceImpl
implements IBalance {
    public String pack(BankBalanceRequest request) {
        Element root = ZSB_DC_Packer.buildHead("200108", RequestContextUtils.getRequestContext().getBankRequestSeq());
        Element body = JDomUtils.addChild((Element)root, (String)"body");
        Element record = JDomUtils.addChild((Element)body, (String)"record");
        JDomUtils.addChild((Element)record, (String)"acno", (String)request.getAcnt().getAccNo());
        JDomUtils.addChild((Element)record, (String)"cur_code", (String)request.getBankCurrency());
        String encoding = RequestContextUtils.getCharset();
        String xmlStr = JDomUtils.root2StringWithoutXMLDeclaration((Element)root, (String)encoding);
        return ZSB_DC_Packer.buildCommonMsg(xmlStr);
    }

    public EBBankBalanceResponse parse(BankBalanceRequest request, String responseStr) {
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)responseStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)ShowTipUtil.getResponseErrorTips((String)rsp.getResponseCode(), (String)rsp.getResponseMessage()));
        }
        Element body = root.getChild("body");
        Element record = (Element)body.getChildren("record").get(0);
        String acno = record.getChildTextTrim("acno");
        String cur_code = record.getChildTextTrim("cur_code");
        String acname = record.getChildTextTrim("acname");
        String balance = record.getChildTextTrim("balance");
        String use_balance = record.getChildTextTrim("use_balance");
        String freeze_bal = record.getChildTextTrim("freeze_bal");
        ArrayList<BalanceInfo> balances = new ArrayList<BalanceInfo>(1);
        BalanceInfo balanceInfo = new BalanceInfo();
        balances.add(balanceInfo);
        this.setBankAcnt(balanceInfo, request.getBankAcntList(), acno);
        this.setBankCurrency(balanceInfo, cur_code);
        this.setBalanceDateTime(balanceInfo, LocalDateTime.now());
        this.setCurrentBalance(balanceInfo, balance);
        this.setAvailableBalance(balanceInfo, use_balance);
        return new EBBankBalanceResponse(balances);
    }

    public String getDeveloper() {
        return "mukan_huang";
    }

    public String getBizCode() {
        return "200108";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u6d59\u5546\u94f6\u884c\u67e5\u8be2\u4f59\u989d\u63a5\u53e3", (String)"TodayBalanceImpl_2", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]);
    }

    public String recv(InputStream inputStream) {
        return ZSB_DC_Parser.parseRecvMsg(super.recv(inputStream));
    }
}

