/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.zsb.dc.services.detail;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.zsb.dc.services.ZSB_DC_Parser;
import kd.ebg.aqap.banks.zsb.dc.services.detail.ResponseFileUtils;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.utils.DetailSysFiled;
import kd.ebg.aqap.common.framework.match.MatchRule;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.exception.EBServiceException;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class DetailParse {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(DetailParse.class);
    private static final DetailParse instance = new DetailParse();

    public static DetailParse getInstance() {
        return instance;
    }

    public List<DetailInfo> parseHisDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return DetailParse.parseDetail(rqst, rspStr);
    }

    public List<DetailInfo> parseTodayDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        return DetailParse.parseDetail(rqst, rspStr);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<DetailInfo> parseDetail(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        ArrayList<DetailInfo> detailList = new ArrayList<DetailInfo>(16);
        String encoding = RequestContextUtils.getCharset();
        Element root = JDomUtils.string2Root((String)rspStr, (String)encoding);
        BankResponse rsp = ZSB_DC_Parser.parseResponeCode(root);
        if (!"0_0000".equalsIgnoreCase(rsp.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u4ea4\u6613\u660e\u7ec6\u5931\u8d25\uff0c\u539f\u56e0:%1$s, %2$s", (String)"DetailParse_6", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), rsp.getResponseCode(), rsp.getResponseMessage()));
        }
        Element head = root.getChild("head");
        String file_flag = head.getChildTextTrim("file_flag");
        logger.info("\u4ea4\u6613\u660e\u7ec6\u8fd4\u56de file_flag: " + file_flag);
        Element body = root.getChild("body");
        String record_num = body.getChildTextTrim("record_num");
        String field_num = body.getChildTextTrim("field_num");
        if ("0".equalsIgnoreCase(record_num)) {
            return detailList;
        }
        String[] splits = new String[]{};
        if ("1".equalsIgnoreCase(file_flag)) {
            String file_name = body.getChildTextTrim("file_name");
            splits = ResponseFileUtils.getDetailRspRecords(file_name);
        } else {
            if (!"0".equalsIgnoreCase(file_flag)) throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684file_flag\u5b57\u6bb5\u4e0d\u6b63\u786e\uff0c\u5bfc\u81f4\u94f6\u4f01\u4e91\u65e0\u6cd5\u83b7\u53d6\u660e\u7ec6\u8bb0\u5f55\u3002", (String)"DetailParse_1", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
            String serial_record = body.getChildTextTrim("serial_record");
            splits = StringUtils.split((String)serial_record, (String)"|");
        }
        int recordNum = Integer.parseInt(record_num);
        int fieldNum = Integer.parseInt(field_num);
        HashMap<String, Integer> countMap = new HashMap<String, Integer>(16);
        for (int i = 1; i <= recordNum; ++i) {
            String serial_no = splits[fieldNum * i + 0];
            String acno = splits[fieldNum * i + 1];
            String cur_code = splits[fieldNum * i + 2];
            String tr_acdt = splits[fieldNum * i + 3];
            String tr_time = splits[fieldNum * i + 4];
            String acname = splits[fieldNum * i + 7];
            String oppAcntNumber = splits[fieldNum * i + 8];
            String oppName = splits[fieldNum * i + 10];
            String oppBank = splits[fieldNum * i + 11];
            String crdr_flag = splits[fieldNum * i + 23];
            String amt = splits[fieldNum * i + 24];
            String balance = splits[fieldNum * i + 25];
            String summary = splits[fieldNum * i + 34];
            String postscript = splits[fieldNum * i + 35];
            String tr_timestamp = splits[fieldNum * i + 36];
            if (!rqst.getAcnt().getAccNo().equalsIgnoreCase(acno)) {
                logger.info("===\u8bf7\u6c42\u8d26\u53f7[" + rqst.getAcnt().getAccNo() + "]\u548c\u94f6\u884c\u8fd4\u56de\u8d26\u53f7[" + acno + "]\u4e0d\u4e00\u81f4\uff0c\u88ab\u8fc7\u6ee4\u7684\u660e\u7ec6===");
                continue;
            }
            DetailInfo detail = new DetailInfo();
            detail.setAccNo(acno);
            detail.setAccName(acname);
            detail.setOppAccNo(oppAcntNumber);
            detail.setOppAccName(oppName);
            detail.setBankName(oppBank);
            if (!StringUtils.isEmpty((String)postscript) && postscript.contains("KD@")) {
                String bankDetailSeqId = postscript.substring(0, postscript.indexOf("KD@"));
                DetailSysFiled.set((DetailInfo)detail, (String)"KDRetFlag", (String)bankDetailSeqId);
                postscript = postscript.substring(bankDetailSeqId.length() + "KD@".length());
                detail.setExplanation(postscript);
            }
            detail.setCurrency(cur_code);
            try {
                if (StringUtils.isEmpty((String)tr_acdt)) {
                    if (StringUtils.isEmpty((String)tr_timestamp)) throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u94f6\u884c\u8fd4\u56de\u7684\u4ea4\u6613\u65f6\u95f4\u4e3a\u7a7a\u3002", (String)"DetailParse_2", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]));
                    detail.setTransTime(LocalDateTime.parse(tr_timestamp, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                } else {
                    detail.setTransTime(LocalDateTime.parse(tr_acdt + tr_time, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
                }
            }
            catch (Exception e) {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u67e5\u8be2\u5931\u8d25,\u539f\u56e0\uff1a\u4ea4\u6613\u65f6\u95f4\u683c\u5f0f\u5316\u5f02\u5e38.%s", (String)"DetailParse_7", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
            }
            detail.setTransDate(LocalDate.parse(tr_acdt, DateTimeFormatter.BASIC_ISO_DATE));
            if (!StringUtils.isEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if ("D".equalsIgnoreCase(crdr_flag.trim())) {
                detail.setDebitAmount(new BigDecimal(amt));
                detail.setCreditAmount(new BigDecimal("0"));
            } else {
                if (!"C".equalsIgnoreCase(crdr_flag.trim())) throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684\u501f\u8d37\u6807\u5fd7crdr_flag\u4e3a%s\uff0c\u671f\u5f85\u8fd4\u56deC\u6216\u8005D\u3002", (String)"DetailParse_8", (String)"ebg-aqap-banks-zsb-dc", (Object[])new Object[0]), crdr_flag));
                detail.setDebitAmount(new BigDecimal("0"));
                detail.setCreditAmount(new BigDecimal(amt));
            }
            detail.setExplanation(summary);
            StringBuilder sb = new StringBuilder();
            sb.append(rqst.getAcnt().getAccNo()).append("-").append(tr_acdt).append("-").append(serial_no);
            DetailSysFiled.set((DetailInfo)detail, (String)"receiptNo", (String)sb.toString());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("serialNo", (Object)serial_no);
            jsonObject.put("tr_acdt", (Object)tr_acdt);
            jsonObject.put("serial_no", (Object)serial_no);
            String accNo = rqst.getAcnt().getAccNo();
            String transDate = tr_acdt;
            String jsonStr = jsonObject.toJSONString();
            String receiptNo = MatchRule.getInstance().getReceiptNo(accNo, transDate, jsonStr);
            if (countMap.containsKey(receiptNo)) {
                int count = (Integer)countMap.get(receiptNo) + 1;
                countMap.put(receiptNo, count);
                receiptNo = receiptNo + "-" + String.format("%04d", count);
            } else {
                countMap.put(receiptNo, 0);
            }
            detail.setJsonMap(jsonStr);
            detail.setReceiptNo(receiptNo);
            detail.setBankDetailNo(serial_no);
            detailList.add(detail);
        }
        return detailList;
    }

    private static List<DetailInfo> parseDetailTest(BankDetailRequest rqst, String rspStr) throws EBServiceException {
        String file_name = "40379001040036148-20181009-117901033-01030405.pdf";
        ResponseFileUtils.getDetailRspRecords(file_name);
        return null;
    }
}

