/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.payment;

import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.ParserHelper;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.EBContext;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.string.StringUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentQuery
extends AbstractQueryPayImpl
implements IQueryPay {
    public int getBatchSize() {
        return 1;
    }

    public String getDeveloper() {
        return "Alic";
    }

    public String getBizCode() {
        return "otherAccQry";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u5212\u62e8\u3001\u884c\u5185\u3001\u8de8\u884c\u8f6c\u8d26\u7ed3\u679c\u67e5\u8be2\u3002", (String)"PaymentQuery_0", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]);
    }

    public String pack(BankPayRequest request) {
        HashMap<String, String> map = new HashMap<String, String>(8);
        PaymentInfo paymentInfo = (PaymentInfo)request.getPaymentInfos().get(0);
        String serialNo = PaymentInfoSysFiled.get((PaymentInfo)paymentInfo, (String)"pay_serial");
        if (StringUtils.isEmpty((String)serialNo)) {
            throw EBExceiptionUtil.payUnknownException((String)ResManager.loadKDString((String)"\u6d41\u6c34\u53f7orderFlowNo\u4e3a\u7a7a\u3002", (String)"PaymentQuery_1", (String)"ebg-aqap-banks-sdcs-dc", (Object[])new Object[0]));
        }
        map.put("orderFlowNo", serialNo);
        return PackerHelper.packXML(map, this.getBizCode());
    }

    public EBBankPayResponse parse(BankPayRequest request, String responseStr) {
        Element root = JDomUtils.string2Root((String)responseStr.substring(56), (String)EBContext.getContext().getCharsetName());
        Element opRep = root.getChild("opRep");
        ParserHelper.parserQueryResult(request.getPaymentInfos(), opRep);
        return new EBBankPayResponse(request.getPaymentInfos());
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }
}

