/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.sdcs.dc.services.payment.salary;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import kd.ebg.aqap.banks.sdcs.dc.services.PackerHelper;
import kd.ebg.aqap.banks.sdcs.dc.services.payment.salary.QueryPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.AbstractPayImpl;
import kd.ebg.aqap.business.payment.atomic.IPay;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.business.payment.utils.PaymentInfoSysFiled;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.aqap.common.utils.BigDecimalHelper;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.framework.communication.ConnectionFactory;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class PaymentImpl
extends AbstractPayImpl
implements IPay {
    public int getBatchSize() {
        return 2000;
    }

    public Class<? extends IQueryPay> defaultQueryClass() {
        return QueryPaymentImpl.class;
    }

    public String getDeveloper() {
        return "";
    }

    public String getBizCode() {
        return "";
    }

    public String getBizDesc() {
        return "";
    }

    public boolean match(PaymentInfo paymentInfo) {
        return "pay_for_salary".equalsIgnoreCase(paymentInfo.getSubBizType());
    }

    public String pack(BankPayRequest request) {
        List paymentInfos = request.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String serial = PackerHelper.getSeq();
        PaymentInfoSysFiled.set((List)paymentInfos, (String)"pay_serial", (String)serial);
        Element bodyEelement = PackerHelper.createRequestBody("agencyPay", serial);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(8);
        map.put("payAccount", paymentInfo.getAccNo());
        map.put("payAccountName", paymentInfo.getAccName());
        map.put("totalNumber", String.valueOf(paymentInfos.size()));
        map.put("totalAmount", BigDecimalHelper.plain2((BigDecimal)this.calcTotalAmt(paymentInfos)));
        map.put("payMonth", DateTimeUtils.format((Date)new Date(), (String)"yyyyMM"));
        map.put("currencyType", paymentInfo.getCurrency());
        map.put("orderFlowNo", serial);
        map.put("dscrpCod", "0002");
        map.put("trsDateTime", DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddhhmmss"));
        Element element = PackerHelper.crateParamElement(map);
        Element tranDeatail = new Element("tranDetail");
        LinkedHashMap<String, String> rowMap = new LinkedHashMap<String, String>(8);
        for (PaymentInfo pInfo : paymentInfos) {
            rowMap.put("SalaryId", pInfo.getBankSerialNo());
            rowMap.put("employeeId", "");
            rowMap.put("employeeName", pInfo.getIncomeAccName());
            rowMap.put("cardNo", pInfo.getIncomeAccNo());
            rowMap.put("payAmount", pInfo.getAmount().toString());
            rowMap.put("comment", pInfo.getExplanation());
            JDomUtils.addChild((Element)tranDeatail, (Element)PackerHelper.crateElement("row", rowMap));
        }
        JDomUtils.addChild((Element)element, (Element)tranDeatail);
        JDomUtils.addChild((Element)bodyEelement, (Element)element);
        Element rootElement = PackerHelper.createRequestHander(bodyEelement);
        JDomUtils.addChild((Element)rootElement, (Element)bodyEelement);
        StringBuilder stringBuilder = PackerHelper.createReportHander(rootElement, "agencyPay", serial);
        String xml = JDomUtils.root2StringNoIndentLineNoSeparator((Element)rootElement, (String)RequestContextUtils.getCharset());
        return stringBuilder.append(xml).toString();
    }

    public EBBankPayResponse parse(BankPayRequest request, String rspStr) {
        List paymentInfos = request.getPaymentInfos();
        Element root = JDomUtils.string2Root((String)rspStr.substring(56), (String)RequestContextUtils.getCharset());
        Element opRep = root.getChild("opRep");
        String returnCode = opRep.getChildTextTrim("hostReturnCode");
        String errMsg = opRep.getChildTextTrim("hostErrorMessage");
        if (Pattern.matches("0+", returnCode)) {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.SUBMITED, (String)"", (String)returnCode, (String)errMsg);
        } else {
            EBGBusinessUtils.setPaymentState((List)paymentInfos, (PaymentState)PaymentState.UNKNOWN, (String)"", (String)returnCode, (String)errMsg);
        }
        return new EBBankPayResponse(paymentInfos);
    }

    public void configFactory(ConnectionFactory factory) {
        factory.setUri(PackerHelper.addUrl());
    }

    public BigDecimal calcTotalAmt(List<PaymentInfo> paymentInfos) {
        BigDecimal total = new BigDecimal("0.00");
        for (PaymentInfo paymentInfo : paymentInfos) {
            total = BigDecimalHelper.add((BigDecimal)total, (BigDecimal)paymentInfo.getAmount());
        }
        return total;
    }
}

