/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.bank.meta;

import com.alibaba.fastjson.JSONObject;
import com.google.common.io.Resources;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.framework.bank.meta.BankVersionMetaInfo;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;

public abstract class BankMetaDataInfo {
    public String host = "";
    public String port = "";
    public String protocol = "http";
    public int timeout = 3;
    public String charset = "GBK";
    public String bankShortName;
    public String bankName;
    public String bankVersionID;
    public String bankVersionName;
    public String description;
    public List<String> keyNames;
    public int concurrentCount;
    public int sortNum;
    public boolean isConcurrentCountReadonly = false;
    public boolean isProtocolReadonly = true;
    String ipName = ResManager.loadKDString((String)"\u524d\u7f6e\u673aIP\u5730\u5740", (String)"BankMetaDataInfo_0", (String)"ebg-aqap-common", (Object[])new Object[0]);
    String ipDesc = ResManager.loadKDString((String)"\u5b89\u88c5\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\u7684\u670d\u52a1\u5668IP", (String)"BankMetaDataInfo_1", (String)"ebg-aqap-common", (Object[])new Object[0]);
    String portName = ResManager.loadKDString((String)"\u7aef\u53e3\u53f7", (String)"BankMetaDataInfo_2", (String)"ebg-aqap-common", (Object[])new Object[0]);
    String portDesc = ResManager.loadKDString((String)"\u94f6\u884c\u524d\u7f6e\u673a\u542f\u52a8\u7684\u76d1\u542c\u7aef\u53e3\u53f7", (String)"BankMetaDataInfo_3", (String)"ebg-aqap-common", (Object[])new Object[0]);
    String exProtocolName = ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"BankMetaDataInfo_4", (String)"ebg-aqap-common", (Object[])new Object[0]);
    MultiLangEnumBridge mlIpName = new MultiLangEnumBridge("\u524d\u7f6e\u673aIP\u5730\u5740", "BankMetaDataInfo_0", "ebg-aqap-common");
    MultiLangEnumBridge mlIpDesc = new MultiLangEnumBridge("\u5b89\u88c5\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\u7684\u670d\u52a1\u5668IP", "BankMetaDataInfo_1", "ebg-aqap-common");
    MultiLangEnumBridge mlPortName = new MultiLangEnumBridge("\u7aef\u53e3\u53f7", "BankMetaDataInfo_2", "ebg-aqap-common");
    MultiLangEnumBridge mlPortDesc = new MultiLangEnumBridge("\u94f6\u884c\u524d\u7f6e\u673a\u542f\u52a8\u7684\u76d1\u542c\u7aef\u53e3\u53f7", "BankMetaDataInfo_3", "ebg-aqap-common");
    MultiLangEnumBridge mlExProtocolName = new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "BankMetaDataInfo_4", "ebg-aqap-common");
    String exProtocolDesc = "";

    public boolean isConcurrentCountReadonly() {
        return this.isConcurrentCountReadonly;
    }

    public MultiLangEnumBridge getMlIpName() {
        return this.mlIpName;
    }

    public void setMlIpName(MultiLangEnumBridge mlIpName) {
        this.mlIpName = mlIpName;
    }

    public MultiLangEnumBridge getMlIpDesc() {
        return this.mlIpDesc;
    }

    public void setMlIpDesc(MultiLangEnumBridge mlIpDesc) {
        this.mlIpDesc = mlIpDesc;
    }

    public MultiLangEnumBridge getMlPortName() {
        return this.mlPortName;
    }

    public void setMlPortName(MultiLangEnumBridge mlPortName) {
        this.mlPortName = mlPortName;
    }

    public MultiLangEnumBridge getMlPortDesc() {
        return this.mlPortDesc;
    }

    public void setMlPortDesc(MultiLangEnumBridge mlPortDesc) {
        this.mlPortDesc = mlPortDesc;
    }

    public MultiLangEnumBridge getMlExProtocolName() {
        return this.mlExProtocolName;
    }

    public void setMlExProtocolName(MultiLangEnumBridge mlExProtocolName) {
        this.mlExProtocolName = mlExProtocolName;
    }

    public String getIpName() {
        return this.ipName;
    }

    public void setIpName(String ipName) {
        this.ipName = ipName;
    }

    public String getIpDesc() {
        return this.ipDesc;
    }

    public void setIpDesc(String ipDesc) {
        this.ipDesc = ipDesc;
    }

    public String getPortName() {
        return this.portName;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortDesc() {
        return this.portDesc;
    }

    public void setPortDesc(String portDesc) {
        this.portDesc = portDesc;
    }

    public String getExProtocolName() {
        return this.exProtocolName;
    }

    public void setExProtocolName(String exProtocolName) {
        this.exProtocolName = exProtocolName;
    }

    public String getExProtocolDesc() {
        return this.exProtocolDesc;
    }

    public void setExProtocolDesc(String exProtocolDesc) {
        this.exProtocolDesc = exProtocolDesc;
    }

    public Builder builder() {
        return new Builder();
    }

    public abstract void baseConfigInit();

    public abstract void metaDataInit();

    public List<BankVersionMetaInfo> initBankVersionMetaExtInfo(String fileName) {
        ArrayList<BankVersionMetaInfo> metaInfos = new ArrayList<BankVersionMetaInfo>(16);
        try {
            URL url = Resources.getResource((String)fileName);
            String content = Resources.toString((URL)url, (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = JSONObject.parseObject((String)content);
            for (String key : jsonObject.keySet()) {
                JSONObject bankInfo = jsonObject.getJSONObject(key);
                BankVersionMetaInfo metaInfo = BankVersionMetaInfo.builder().bankShortName(bankInfo.getString("bankShortName")).bankName(bankInfo.getString("bankName")).bankVersionID(bankInfo.getString("bankVersionID")).bankVersionName(bankInfo.getString("bankVersionName")).description(bankInfo.getString("description")).keyNames(this.getList(bankInfo.getString("keyNames"))).concurrentCount(1).build();
                metaInfos.add(metaInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return metaInfos;
    }

    public List<String> getList(String keyNames) {
        String[] str = keyNames.split(",");
        return Arrays.asList(str);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        if (port > 0) {
            this.port = String.valueOf(port);
        }
    }

    public void setExchangeProtocol(String protocol) {
        this.protocol = protocol;
        this.isProtocolReadonly = true;
    }

    public void setExchangeProtocol(String protocol, boolean readOnly) {
        this.protocol = protocol;
        this.isProtocolReadonly = readOnly;
    }

    public void setTimeOut(int time) {
        this.timeout = time;
    }

    public void setCharSet(String charset) {
        this.charset = charset;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getBankShortName() {
        return this.bankShortName;
    }

    public void setBankShortName(String bankShortName) {
        this.bankShortName = bankShortName;
    }

    public String getBankName() {
        return this.bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBankVersionID() {
        return this.bankVersionID;
    }

    public void setBankVersionID(String bankVersionID) {
        this.bankVersionID = bankVersionID;
    }

    public String getBankVersionName() {
        return this.bankVersionName;
    }

    public void setBankVersionName(String bankVersionName) {
        this.bankVersionName = bankVersionName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getKeyNames() {
        return this.keyNames;
    }

    public void setKeyNames(List<String> keyNames) {
        this.keyNames = keyNames;
    }

    public int getConcurrentCount() {
        return this.concurrentCount;
    }

    public void setConcurrentCount(int concurrentCount) {
        this.concurrentCount = concurrentCount;
    }

    public boolean getConcurrentCountReadonlyInf() {
        return this.isConcurrentCountReadonly;
    }

    public void setConcurrentCountReadonly(boolean isreadonly) {
        this.isConcurrentCountReadonly = isreadonly;
    }

    public boolean isProtocolReadonly() {
        return this.isProtocolReadonly;
    }

    public void setProtocolReadonly(boolean protocolReadonly) {
        this.isProtocolReadonly = protocolReadonly;
    }

    public int getSortNum() {
        return this.sortNum;
    }

    public void setSortNum(int sortNum) {
        this.sortNum = sortNum;
    }

    public class Builder {
        String ipName = ResManager.loadKDString((String)"\u524d\u7f6e\u673aIP\u5730\u5740", (String)"BankMetaDataInfo_0", (String)"ebg-aqap-common", (Object[])new Object[0]);
        String ipDesc = ResManager.loadKDString((String)"\u5b89\u88c5\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\u7684\u670d\u52a1\u5668IP", (String)"BankMetaDataInfo_1", (String)"ebg-aqap-common", (Object[])new Object[0]);
        String portName = ResManager.loadKDString((String)"\u7aef\u53e3\u53f7", (String)"BankMetaDataInfo_2", (String)"ebg-aqap-common", (Object[])new Object[0]);
        String portDesc = ResManager.loadKDString((String)"\u94f6\u884c\u524d\u7f6e\u673a\u542f\u52a8\u7684\u76d1\u542c\u7aef\u53e3\u53f7", (String)"BankMetaDataInfo_3", (String)"ebg-aqap-common", (Object[])new Object[0]);
        String exProtocolName = ResManager.loadKDString((String)"\u901a\u8baf\u534f\u8bae", (String)"BankMetaDataInfo_4", (String)"ebg-aqap-common", (Object[])new Object[0]);
        MultiLangEnumBridge mlIpName = new MultiLangEnumBridge("\u524d\u7f6e\u673aIP\u5730\u5740", "BankMetaDataInfo_0", "ebg-aqap-common");
        MultiLangEnumBridge mlIpDesc = new MultiLangEnumBridge("\u5b89\u88c5\u94f6\u884c\u524d\u7f6e\u673a\u8f6f\u4ef6\u7684\u670d\u52a1\u5668IP", "BankMetaDataInfo_1", "ebg-aqap-common");
        MultiLangEnumBridge mlPortName = new MultiLangEnumBridge("\u7aef\u53e3\u53f7", "BankMetaDataInfo_2", "ebg-aqap-common");
        MultiLangEnumBridge mlPortDesc = new MultiLangEnumBridge("\u94f6\u884c\u524d\u7f6e\u673a\u542f\u52a8\u7684\u76d1\u542c\u7aef\u53e3\u53f7", "BankMetaDataInfo_3", "ebg-aqap-common");
        MultiLangEnumBridge mlExProtocolName = new MultiLangEnumBridge("\u901a\u8baf\u534f\u8bae", "BankMetaDataInfo_4", "ebg-aqap-common");
        String exProtocolDesc = "";

        public Builder ipName(String ipName) {
            this.ipName = ipName;
            return this;
        }

        public Builder ipName(MultiLangEnumBridge ipName) {
            this.mlIpName = ipName;
            return this;
        }

        public Builder ipDesc(String ipDesc) {
            this.ipDesc = ipDesc;
            return this;
        }

        public Builder ipDesc(MultiLangEnumBridge ipDesc) {
            this.mlIpDesc = ipDesc;
            return this;
        }

        public Builder portName(String portName) {
            this.portName = portName;
            return this;
        }

        public Builder portName(MultiLangEnumBridge portName) {
            this.mlPortName = portName;
            return this;
        }

        public Builder portDesc(String portDesc) {
            this.portDesc = portDesc;
            return this;
        }

        public Builder portDesc(MultiLangEnumBridge portDesc) {
            this.mlPortDesc = portDesc;
            return this;
        }

        public Builder exProtocolName(String exProtocolName) {
            this.exProtocolName = exProtocolName;
            return this;
        }

        public Builder exProtocolName(MultiLangEnumBridge exProtocolName) {
            this.mlExProtocolName = exProtocolName;
            return this;
        }

        public Builder exProtocolDesc(String exProtocolDesc) {
            this.exProtocolDesc = exProtocolDesc;
            return this;
        }

        public void build() {
            BankMetaDataInfo.this.setIpName(this.ipName);
            BankMetaDataInfo.this.setIpDesc(this.ipDesc);
            BankMetaDataInfo.this.setPortName(this.portName);
            BankMetaDataInfo.this.setPortDesc(this.portDesc);
            BankMetaDataInfo.this.setExProtocolName(this.exProtocolName);
            BankMetaDataInfo.this.setMlIpName(this.mlIpName);
            BankMetaDataInfo.this.setMlIpDesc(this.mlIpDesc);
            BankMetaDataInfo.this.setMlPortName(this.mlPortName);
            BankMetaDataInfo.this.setMlPortDesc(this.mlPortDesc);
            BankMetaDataInfo.this.setMlExProtocolName(this.mlExProtocolName);
            BankMetaDataInfo.this.setExProtocolDesc(this.exProtocolDesc);
        }
    }
}

