/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.reconciliation;

import java.util.List;
import kd.ebg.aqap.common.framework.reconciliation.IKDProcessor;
import kd.ebg.aqap.common.framework.reconciliation.KDRule;
import kd.ebg.aqap.common.framework.reconciliation.find.FindNodeInfo;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public abstract class AbstractKDProcessor
implements IKDProcessor {
    EBGLogger logger = EBGLogger.getInstance().getLogger(AbstractKDProcessor.class);

    public abstract List<FindNodeInfo> handle(String var1, String var2);

    @Override
    public String processPay(String content, List<PaymentInfo> paymentInfoList, KDRule rule) {
        this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\uff1a{}", (Object)rule.toString());
        String result = content;
        if (rule.isMergeFlag() != paymentInfoList.get(0).is2Merge()) {
            this.logger.info("\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u5931\u6548\uff0c\u89c4\u5219\u7684\u6c47\u603b\u660e\u7ec6{}\u4e0e\u5b9e\u9645\u4ed8\u6b3e\u5e76\u7b14\u6807\u8bc6{}\u4e0d\u5339\u914d\u3002", new Object[]{rule.isMergeFlag(), paymentInfoList.get(0).is2Merge()});
            return content;
        }
        List<FindNodeInfo> nodeInfoList = this.handle(content, rule.getNodePath());
        if (nodeInfoList.size() > 0 && nodeInfoList.size() == paymentInfoList.size()) {
            for (int i = 0; i < nodeInfoList.size(); ++i) {
                String id = rule.isMergeFlag() ? paymentInfoList.get(i).getBankBatchSeqID() : paymentInfoList.get(i).getBankDetailSeqID();
                String value = rule.getKDFlagID(id) + nodeInfoList.get(i).getNodeValue();
                value = this.handleExplanation(rule, value);
                nodeInfoList.get(i).setNodeValue(value);
                paymentInfoList.get(i).setKdFlagID(id);
                if (!rule.isBankRefFlag()) continue;
                paymentInfoList.get(i).setBankRefID(id);
            }
            result = this.repack(content, nodeInfoList);
        } else if (nodeInfoList.size() == 0) {
            this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\u5931\u6548\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u672a\u5339\u914d\u5230\u5bf9\u8d26\u7801\u89c4\u5219\u7684\u4e1a\u52a1\u5b57\u6bb5\u3002");
        } else {
            this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\u5931\u6548\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u5339\u914d\u5230\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u7684\u4e1a\u52a1\u5b57\u6bb5\u6570\u76ee\u4e0e\u4ea4\u6613\u660e\u7ec6\u89e3\u6790\u6570\u76ee\u4e0d\u4e00\u81f4\u3002");
        }
        return result;
    }

    public String repack(String content, List<FindNodeInfo> nodeInfoList) {
        if (nodeInfoList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String tempString = "";
            for (int i = 0; i < nodeInfoList.size(); ++i) {
                tempString = i == 0 ? content.substring(0, nodeInfoList.get(i).getStartIndex()) : content.substring(nodeInfoList.get(i - 1).getEndIndex(), nodeInfoList.get(i).getStartIndex());
                sb.append(tempString).append(nodeInfoList.get(i).getNodeValue());
                if (i != nodeInfoList.size() - 1) continue;
                tempString = content.substring(nodeInfoList.get(i).getEndIndex());
                sb.append(tempString);
            }
            this.logger.info("\u6267\u884c\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\uff0c\u5b8c\u6210\u91cd\u65b0\u6253\u5305\u3002");
            return sb.toString();
        }
        this.logger.info("\u6267\u884c\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\uff0c\u672a\u53d1\u73b0\u5bf9\u8d26\u7801\u5b57\u6bb5\u3002");
        return content;
    }

    @Override
    public void processDetail(String content, List<DetailInfo> detailInfoList, KDRule rule) {
        this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\uff1a{}", (Object)rule.toString());
        List<FindNodeInfo> nodeInfoList = this.handle(content, rule.getNodePath());
        if (nodeInfoList.size() > 0 && nodeInfoList.size() == detailInfoList.size()) {
            for (int i = 0; i < detailInfoList.size(); ++i) {
                this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\uff0c\u5339\u914d\u5b57\u6bb5\u503c\u4e3a{}", (Object)nodeInfoList.get(i).getNodeValue());
                String id = rule.parseKDFlagIDFromDetail(nodeInfoList.get(i).getNodeValue());
                this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\uff0c\u89e3\u6790\u5bf9\u8d26\u7801\u4e3a{}", (Object)id);
                if (!StringUtils.isNotEmpty((String)id) || id.equalsIgnoreCase(detailInfoList.get(i).getPayBankDetailSeqID())) continue;
                detailInfoList.get(i).setPayBankDetailSeqID(id);
            }
        } else if (nodeInfoList.size() == 0) {
            this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\u5931\u6548\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u672a\u5339\u914d\u5230\u5bf9\u8d26\u7801\u89c4\u5219\u7684\u4e1a\u52a1\u5b57\u6bb5\u3002");
        } else {
            this.logger.info("\u6267\u884c\u5bf9\u8d26\u7801\u89c4\u5219\u5931\u6548\uff0c\u94f6\u884c\u54cd\u5e94\u62a5\u6587\u5339\u914d\u5230\u4ed8\u6b3eKD\u5bf9\u8d26\u7801\u89c4\u5219\u7684\u4e1a\u52a1\u5b57\u6bb5\u6570\u76ee\u4e0e\u4ea4\u6613\u660e\u7ec6\u89e3\u6790\u6570\u76ee\u4e0d\u4e00\u81f4\u3002");
        }
    }

    @Override
    public String handleExplanation(KDRule rule, String explanation) {
        boolean isExplanation;
        boolean bl = isExplanation = !rule.isBankRefFlag();
        if (isExplanation) {
            int realSize = this.getExplanationRealSize(rule.getBankVersion(), explanation);
            if (rule.getExplanationSize() > 0 && realSize > rule.getExplanationSize()) {
                this.logger.info("\u5bf9\u8d26\u7801\u5b57\u6bb5\u5b9e\u9645\u957f\u5ea6{}\u8d85\u8fc7\u6700\u5927\u957f\u5ea6{}\uff0c\u6309\u7167\u6700\u5927\u957f\u5ea6\u8fdb\u884c\u622a\u53d6", new Object[]{realSize, rule.getExplanationSize()});
                explanation = explanation.substring(0, rule.getExplanationSize());
            }
        }
        return explanation;
    }

    private int getExplanationRealSize(String bankVersion, String explanation) {
        return explanation.length();
    }
}

