/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingBankField;
import kd.ebg.aqap.common.entity.biz.financing.query.FinancingProductDetail;
import kd.ebg.aqap.common.model.repository.BdBusinessRespository;
import kd.ebg.aqap.common.model.repository.FinancingDetailRespository;
import kd.ebg.aqap.common.model.repository.FinancingSyncRecordRespository;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.annotation.Service;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.model.data.Page;
import kd.ebg.egf.common.model.data.PageRequest;
import kd.ebg.egf.common.model.data.Pageable;
import kd.ebg.egf.common.utils.collect.CollectionUtil;

@Service
public class FinancingDetailService {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(FinancingDetailService.class);
    private FinancingDetailRespository financingDetailRespository = SpringContextUtil.getBean(FinancingDetailRespository.class);
    private FinancingSyncRecordRespository financingSyncRecordRespository = SpringContextUtil.getBean(FinancingSyncRecordRespository.class);
    private BdBusinessRespository bdBusinessRespository = SpringContextUtil.getBean(BdBusinessRespository.class);

    public boolean exitsFinancingRecord(String bankVersionID, LocalDate syncDate) {
        return this.financingSyncRecordRespository.exitsByBankVersionIDAndSyncDate(bankVersionID, syncDate);
    }

    public void insertOrUpdate(List<FinancingProductDetail> details, boolean isSearchByProductCode) {
        if (CollectionUtil.isEmpty(details)) {
            return;
        }
        TXHandle h = TX.requiresNew();
        String bankVersionID = details.get(0).getBankVersionID();
        try {
            if (isSearchByProductCode) {
                this.financingDetailRespository.updateWhenSourceNotEmpty(details.get(0));
                this.bdBusinessRespository.insertOrUpdate(details.get(0));
            } else {
                this.financingDetailRespository.deleteByBankVersionID(bankVersionID);
                this.financingDetailRespository.insertAll(details);
                this.bdBusinessRespository.deleteFinancingBusinessByBankVersionID(bankVersionID);
                this.bdBusinessRespository.insertAll(details);
            }
        }
        catch (Exception e) {
            h.markRollback();
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u7406\u8d22\u8be6\u60c5\u5199\u5165\u6570\u636e\u5e93\u51fa\u73b0\u5f02\u5e38\u3002", (String)"FinancingDetailService_0", (String)"ebg-aqap-common", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            try {
                h.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public Page<FinancingProductDetail> getFinancingProductDetailPage(String bankVersionID, String bankLoginID, String productCode, int pageNum, int pageSize) {
        PageRequest pageRequest = PageRequest.of((int)(pageNum - 1), (int)pageSize);
        Page<FinancingProductDetail> result = this.financingDetailRespository.findByBankVersionID(bankVersionID, productCode, (Pageable)pageRequest);
        if (CollectionUtil.isNotEmpty((Collection)result.getContent())) {
            ArrayList<String> productCodes = new ArrayList<String>(result.getSize());
            for (FinancingProductDetail detail : result.getContent()) {
                productCodes.add(detail.getProductCode());
            }
            Map<String, List<FinancingBankField>> group = this.bdBusinessRespository.findFinancingByProductCodeInAndBankVersionID(productCodes, bankVersionID);
            for (FinancingProductDetail detail : result.getContent()) {
                detail.setBankLoginID(bankLoginID);
                detail.setBankFields(group.get(detail.getProductCode()));
            }
        }
        return result;
    }
}

