/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.services.mock.pay;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.PaymentInfo;

public class MockPaymentInfoService {
    public static String ENTITY_NAME = "aqap_bd_mock_payment";
    private static MockPaymentInfoService instance = new MockPaymentInfoService();

    public static MockPaymentInfoService getInstance() {
        return instance;
    }

    public void updatePayStatus(String bankBatchSeqID, boolean isFail) {
        QFilter filter = QFilter.of((String)"bank_batch_seq = ?", (Object[])new Object[]{bankBatchSeqID});
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)"pay_status", (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("pay_status", (Object)(isFail ? "13" : "12"));
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public void insertMockPayment(List<PaymentInfo> paymentInfoList, long currencyId) {
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>(16);
        for (PaymentInfo paymentInfo : paymentInfoList) {
            DynamicObject dynamicObject = this.transForm(paymentInfo);
            dynamicObject.set("bd_currency", (Object)currencyId);
            dynamicObjectList.add(dynamicObject);
        }
        DynamicObject[] dynamicObjects = dynamicObjectList.toArray(new DynamicObject[paymentInfoList.size()]);
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    private DynamicObject transForm(PaymentInfo paymentInfo) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        dynamicObject.set("id", (Object)ID.genLongId());
        dynamicObject.set("biz_type", (Object)paymentInfo.getBizType());
        dynamicObject.set("sub_biz_type", (Object)paymentInfo.getSubBizType());
        dynamicObject.set("merge", (Object)paymentInfo.is2Merge());
        dynamicObject.set("urgent", (Object)paymentInfo.is2Urgent());
        dynamicObject.set("abstract_msg", (Object)paymentInfo.getAbstractMsg());
        dynamicObject.set("acc_no", (Object)paymentInfo.getAccNo());
        dynamicObject.set("acc_name", (Object)paymentInfo.getAccName());
        this.setDynamicObject(dynamicObject, "book_date", paymentInfo.getBookingTime());
        dynamicObject.set("batch_seq", (Object)paymentInfo.getBatchSeqID());
        dynamicObject.set("detail_seq", (Object)paymentInfo.getDetailSeqID());
        dynamicObject.set("bank_batch_seq", (Object)paymentInfo.getBankBatchSeqID());
        dynamicObject.set("bank_detail_seq", (Object)paymentInfo.getBankDetailSeqID());
        dynamicObject.set("pay_status", (Object)String.valueOf(paymentInfo.getStatus()));
        dynamicObject.set("error_msg", (Object)paymentInfo.getErrorMsg());
        dynamicObject.set("bank_currency", (Object)paymentInfo.getCurrency());
        dynamicObject.set("currency", (Object)this.getLong(paymentInfo.getIsoCurrencyCode()));
        dynamicObject.set("amount", (Object)paymentInfo.getAmount());
        dynamicObject.set("explanation", (Object)paymentInfo.getExplanation());
        dynamicObject.set("income_accno", (Object)paymentInfo.getIncomeAccNo());
        dynamicObject.set("income_name", (Object)paymentInfo.getIncomeAccName());
        dynamicObject.set("income_address", (Object)paymentInfo.getIncomeBankAddress());
        dynamicObject.set("income_branch_no", (Object)paymentInfo.getIncomeBranchNo());
        dynamicObject.set("income_branch_name", (Object)paymentInfo.getIncomeBranchName());
        if (paymentInfo.getInsertTime() == null) {
            paymentInfo.setInsertTime(LocalDateTime.now());
        }
        this.setDynamicObject(dynamicObject, "insert_time", paymentInfo.getInsertTime());
        dynamicObject.set("route_rec_tag", (Object)paymentInfo.getPackageKey());
        dynamicObject.set("enable", (Object)"1");
        return dynamicObject;
    }

    private long getLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private void setDynamicObject(DynamicObject dynamicObject, String name, Object value) {
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            Date date = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set(name, (Object)date);
        } else {
            dynamicObject.set(name, value);
        }
    }
}

