/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.task;

import java.time.LocalDateTime;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.ebg.aqap.common.framework.properties.SystemPropertyConfig;
import kd.ebg.aqap.common.framework.services.DetailInfoService;
import kd.ebg.aqap.common.utils.SpringContextUtil;
import kd.ebg.egf.common.log.EBGLogger;
import org.slf4j.MDC;

public class DetailArchiveTask
extends AbstractTask {
    EBGLogger logger = EBGLogger.getInstance().getLogger(DetailArchiveTask.class);
    DetailInfoService detailInfoService;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        MDC.put((String)"schedule", (String)"true");
        MDC.put((String)"scheduleLog", (String)String.valueOf(SystemPropertyConfig.isScheduleLogOpen()));
        this.detailInfoService = SpringContextUtil.getBean(DetailInfoService.class);
        this.logger.info("\u5c06\u4e09\u4e2a\u6708\u524d\u7684\u660e\u7ec6\u6570\u636e\u8fdb\u884c\u5f52\u6863\u8f6c\u50a8");
        try {
            this.detailInfoService.archiveDetailInfo(LocalDateTime.now().minusMonths(3L));
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u6613\u660e\u7ec6\u8f6c\u50a8\u5f02\u5e38", (Throwable)e);
        }
        this.clearEBGLog(LocalDateTime.now().minusDays(30L));
    }

    private void clearEBGLog(LocalDateTime time) {
        StringBuilder str = new StringBuilder("dt_query <= ?");
        QFilter filter = QFilter.of((String)str.toString(), (Object[])new Object[]{time});
        DeleteServiceHelper.delete((String)"aqap_new_log", (QFilter[])filter.toArray());
    }
}

