/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.framework.utils;

import java.math.BigDecimal;
import kd.ebg.aqap.common.model.PaymentInfo;

public class PackerUtils {
    public static final BigDecimal ONE_HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static String convertYuan2CentStr(BigDecimal yuan) {
        yuan = yuan.multiply(ONE_HUNDRED);
        yuan = yuan.setScale(0);
        return yuan.toString();
    }

    public static String getTotalAmount(PaymentInfo[] paymentInfos) {
        BigDecimal bigDecimal = new BigDecimal("0.00");
        for (PaymentInfo info : paymentInfos) {
            bigDecimal = bigDecimal.add(info.getAmount());
        }
        return bigDecimal.setScale(2, 4).toString();
    }

    public static boolean isBelowZero(BigDecimal amount) {
        boolean flag = true;
        if (null != amount && amount.compareTo(ZERO) > 0) {
            flag = false;
        }
        return flag;
    }
}

