/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.model.repository;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.ebg.aqap.common.model.PaymentHash;
import kd.ebg.egf.common.annotation.Component;
import kd.ebg.egf.common.utils.DTFactoryUtil;
import kd.ebg.egf.common.utils.string.StringUtils;

@Component
public class PaymentHashRepository {
    private String entity = "aqap_bd_payment_hash";
    private String properties = "id,bank_detail_seq_id,create_time,data_hash,detail_seq_id,custom_id";

    private PaymentHash transPaymentHash(DynamicObject dynamicObject) {
        PaymentHash paymentHash = new PaymentHash();
        paymentHash.setId(dynamicObject.getString("id"));
        paymentHash.setBankDetailSeqID(dynamicObject.getString("bank_detail_seq_id"));
        paymentHash.setCustomID(dynamicObject.getString("custom_id"));
        paymentHash.setDataHash(dynamicObject.getString("data_hash"));
        paymentHash.setDetailSeqID(dynamicObject.getString("detail_seq_id"));
        String time = dynamicObject.getString("create_time");
        if (StringUtils.isNotEmpty((String)time)) {
            paymentHash.setCreateTime(DTFactoryUtil.parseDateTime((String)time));
        }
        return paymentHash;
    }

    private DynamicObject packPaymentHash(PaymentHash paymentHash) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)this.entity);
        dynamicObject.set("bank_detail_seq_id", (Object)paymentHash.getBankDetailSeqID());
        dynamicObject.set("custom_id", (Object)paymentHash.getCustomID());
        dynamicObject.set("data_hash", (Object)paymentHash.getDataHash());
        dynamicObject.set("detail_seq_id", (Object)paymentHash.getDetailSeqID());
        LocalDateTime time = paymentHash.getCreateTime();
        if (time != null) {
            Date createTime = Date.from(time.atZone(ZoneId.systemDefault()).toInstant());
            dynamicObject.set("create_time", (Object)createTime);
        }
        dynamicObject.set("status", (Object)"A");
        return dynamicObject;
    }

    public PaymentHash findByDetailSeqID(String detailSeqID) {
        PaymentHash paymentHash = new PaymentHash();
        QFilter filter = QFilter.of((String)"detail_seq_id=?", (Object[])new Object[]{detailSeqID});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            paymentHash = this.transPaymentHash(dynamicObject);
        }
        return paymentHash;
    }

    public Map<String, String> findByDetailSeqIDList(List<String> detailSeqIDList) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        QFilter filter = new QFilter("detail_seq_id", "in", detailSeqIDList);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String detailSeqID = dynamicObject.getString("detail_seq_id");
                String dataHash = dynamicObject.getString("data_hash");
                result.put(detailSeqID, dataHash);
            }
        }
        return result;
    }

    public PaymentHash findByIdAndCustomID(String id, String customId) {
        PaymentHash paymentHash = new PaymentHash();
        QFilter filter = QFilter.of((String)"id=? and custom_id=?", (Object[])new Object[]{id, customId});
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)this.entity, (String)this.properties, (QFilter[])filter.toArray());
        if (dynamicObject != null) {
            paymentHash = this.transPaymentHash(dynamicObject);
        }
        return paymentHash;
    }

    public PaymentHash save(PaymentHash paymentHash) {
        DynamicObject dynamicObject = this.packPaymentHash(paymentHash);
        DynamicObject[] dynamicObjects = new DynamicObject[]{dynamicObject};
        String id = paymentHash.getId();
        if (!this.isEmpty(id) && QueryServiceHelper.exists((String)this.entity, (Object)id)) {
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        } else {
            Object[] objs = SaveServiceHelper.save((DynamicObject[])dynamicObjects);
            for (int i = 0; i < objs.length; ++i) {
                DynamicObject temp = (DynamicObject)objs[i];
                paymentHash.setId(temp.getString("id"));
            }
        }
        return paymentHash;
    }

    public void insert(List<PaymentHash> paymentHashList) {
        DynamicObject[] dynamicObjects = new DynamicObject[paymentHashList.size()];
        for (int i = 0; i < paymentHashList.size(); ++i) {
            DynamicObject dynamicObject;
            PaymentHash paymentHash = paymentHashList.get(i);
            dynamicObjects[i] = dynamicObject = this.packPaymentHash(paymentHash);
        }
        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
    }

    boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

