/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.common.utils.junit;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.LinkedList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.common.core.utils.Sequence;
import kd.ebg.aqap.common.framework.match.DetailFieldUtil;
import kd.ebg.aqap.common.utils.junit.IMessage;
import kd.ebg.aqap.common.utils.junit.MockShield;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.communication.HttpConnection;
import kd.ebg.egf.common.framework.communication.LoggerConnection;
import kd.ebg.egf.common.framework.communication.TcpConnection;
import kd.ebg.egf.common.log.LogFilterUtil;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedConstruction;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class JUnitMockUtils {
    private static MockedConstruction mockConnection(IMessage<String> message) {
        String charsetName = RequestContextUtils.getCharset();
        String protocol = RequestContextUtils.getBankParameterValue((String)"exchangeProtocol");
        if ("HTTP".equalsIgnoreCase(protocol)) {
            return Mockito.mockConstruction(HttpConnection.class, (mockObj, ctx) -> {
                Mockito.when((Object)mockObj.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)message.recv()).getBytes(charsetName));
                Mockito.when((Object)mockObj.getInputStream()).thenReturn((Object)byteArrayInputStream);
            });
        }
        if ("TCP".equalsIgnoreCase(protocol)) {
            return Mockito.mockConstruction(TcpConnection.class, (mockObj, ctx) -> {
                Mockito.when((Object)mockObj.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)message.recv()).getBytes(charsetName));
                Mockito.when((Object)mockObj.getInputStream()).thenReturn((Object)byteArrayInputStream);
            });
        }
        if (!"HTTPS".equalsIgnoreCase(protocol)) {
            throw EBExceiptionUtil.connectionException((String)String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u534f\u8bae\u7c7b\u578b %s", (String)"ConnectionFactory_0", (String)"ebg-egf-common", (Object[])new Object[0]), protocol));
        }
        return Mockito.mockConstruction(HttpConnection.class, (mockObj, ctx) -> {
            Mockito.when((Object)mockObj.getOutputStream()).thenReturn((Object)new ByteArrayOutputStream());
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)message.recv()).getBytes(charsetName));
            Mockito.when((Object)mockObj.getInputStream()).thenReturn((Object)byteArrayInputStream);
        });
    }

    public static MockedConstruction mockConnection(String msg) {
        return JUnitMockUtils.mockConnection(() -> msg);
    }

    public static MockedConstruction mockConnection(String[] messages) {
        return JUnitMockUtils.mockConnection(new RepeatedMockStub<String[]>(messages));
    }

    public static void mockShield() {
        MockedStatic sequenceMockedStatic = Mockito.mockStatic(Sequence.class);
        MockedStatic resManagerMockedStatic = Mockito.mockStatic(ResManager.class);
        MockedStatic loggerConnectionMockedStatic = Mockito.mockStatic(LoggerConnection.class);
        sequenceMockedStatic.when(Sequence::gen18Sequence).thenReturn((Object)"1");
        ArgumentCaptor sac1 = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor sac2 = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor sac3 = ArgumentCaptor.forClass(String.class);
        resManagerMockedStatic.when(() -> ResManager.loadKDString((String)((String)sac1.capture()), (String)((String)sac2.capture()), (String)((String)sac3.capture()), (Object[])new Object[0])).thenAnswer(invocationOnMock -> (String)invocationOnMock.getArgument(0, String.class));
        loggerConnectionMockedStatic.when(() -> LoggerConnection.writeLogger((String)((String)sac1.capture()), (String)((String)sac2.capture()))).thenAnswer(invocationOnMock -> null);
    }

    public static MockShield getBasicMockShield() {
        MockedStatic loggerConnectionMockedStatic = Mockito.mockStatic(LoggerConnection.class);
        MockedStatic logFilterUtilMockedStatic = Mockito.mockStatic(LogFilterUtil.class);
        MockedStatic detailFieldUtilMockedStatic = Mockito.mockStatic(DetailFieldUtil.class);
        ArgumentCaptor sac1 = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor sac2 = ArgumentCaptor.forClass(String.class);
        loggerConnectionMockedStatic.when(() -> LoggerConnection.writeLogger((String)((String)sac1.capture()), (String)((String)sac2.capture()))).thenAnswer(invocationOnMock -> null);
        logFilterUtilMockedStatic.when(() -> LogFilterUtil.getSendResult((String)((String)ArgumentMatchers.any()))).thenReturn((Object)"");
        logFilterUtilMockedStatic.when(() -> LogFilterUtil.getJsonLog((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)"");
        logFilterUtilMockedStatic.when(() -> LogFilterUtil.getXmlLog((String)((String)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any()))).thenReturn((Object)"");
        DetailFieldUtil mockDetailFieldUtil = (DetailFieldUtil)Mockito.mock(DetailFieldUtil.class);
        Mockito.when((Object)mockDetailFieldUtil.getDetailField((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(null);
        detailFieldUtilMockedStatic.when(DetailFieldUtil::getInstance).thenReturn((Object)mockDetailFieldUtil);
        MockShield mockShield = new MockShield();
        mockShield.addAll(Lists.newArrayList((Object[])new MockedStatic[]{loggerConnectionMockedStatic, logFilterUtilMockedStatic, detailFieldUtilMockedStatic}));
        logFilterUtilMockedStatic.when(() -> LogFilterUtil.getSendResult((String)Mockito.anyString())).thenReturn((Object)"123444");
        return mockShield;
    }

    public static class RepeatedMockStub<T>
    implements IMessage<T> {
        private final LinkedList<T> queue = new LinkedList();

        public RepeatedMockStub(T[] ts) {
            for (T t : ts) {
                this.queue.addLast(t);
            }
        }

        public RepeatedMockStub(T t) {
            this.queue.addLast(t);
        }

        @Override
        public T recv() {
            return this.queue.pollFirst();
        }
    }
}

