/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsurb.dc;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsurb.dc.BankBusinessConfig;
import kd.ebg.aqap.banks.hsurb.dc.services.balance.BalanceImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.detail.DetailImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.PaymentImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.PretreatmentImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.QryPaymentImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.group.GroupPaymentImpl;
import kd.ebg.aqap.banks.hsurb.dc.services.payment.group.QryGroupPaymentImpl;
import kd.ebg.aqap.common.constant.DetailUniqueTypeEnum;
import kd.ebg.aqap.common.framework.bank.meta.BankMetaDataCollector;
import kd.ebg.aqap.common.framework.bank.meta.template.FBEMetaDataTemplate;
import kd.ebg.aqap.common.framework.properties.BankPropertyConfig;
import kd.ebg.egf.common.framework.bank.api.IBankService;
import kd.ebg.egf.common.framework.conf.BankLoginConfigUtil;
import kd.ebg.egf.common.framework.lang.MultiLangEnumBridge;
import kd.ebg.egf.common.model.bank.login.BankLoginConfig;

public class HsurbDcMetaDataImpl
extends FBEMetaDataTemplate
implements BankMetaDataCollector {
    public static final String HttpUri = "HttpUri";
    public static final String CustomerId = "CustomerId";
    public static final String BranchId = "BranchId";
    public static final String SignCharset = "SignCharset";
    public static final String groupId = "groupId";
    public static final String CERTIFICATESN = "certificateSN";

    public void baseConfigInit() {
        this.setExchangeProtocol("HTTP");
        this.setTimeOut(3);
        this.setCharSet("GBK");
    }

    public void metaDataInit() {
        this.setBankName(ResManager.loadKDString((String)"\u5b89\u5fbd\u970d\u5c71\u8054\u5408\u6751\u9547\u94f6\u884c", (String)"HsurbDcMetaDataImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        this.setBankVersionID("HSURB_DC");
        this.setBankShortName("HSURB");
        this.setBankVersionName(ResManager.loadKDString((String)"\u5b89\u5fbd\u970d\u5c71\u8054\u5408\u6751\u9547\u94f6\u884c\u76f4\u8054\u7248", (String)"HsurbDcMetaDataImpl_1", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        this.setDescription(ResManager.loadKDString((String)"\u5b89\u5fbd\u970d\u5c71\u8054\u5408\u6751\u9547\u94f6\u884c", (String)"HsurbDcMetaDataImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        this.setKeyNames(Lists.newArrayList());
    }

    public List<BankLoginConfig> getBankLoginBanksConfig() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)CustomerId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237\u53f7", "HsurbDcMetaDataImpl_2", "ebg-aqap-banks-hsurb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)BranchId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u673a\u6784\u53f7", "HsurbDcMetaDataImpl_3", "ebg-aqap-banks-hsurb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)groupId, (MultiLangEnumBridge)new MultiLangEnumBridge("\u96c6\u56e2\u7f16\u53f7", "HsurbDcMetaDataImpl_4", "ebg-aqap-banks-hsurb-dc"), (String)"", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)CERTIFICATESN, (MultiLangEnumBridge)new MultiLangEnumBridge("\u5ba2\u6237SN", "BankBusinessConfig_2", "ebg-aqap-banks-hsurb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u4f7f\u7528\u4fe1\u5b89\u76d2\u5b50\u7b7e\u540d\u4f7f\u7528\uff0c\u94f6\u884c\u63d0\u4f9b", "BankBusinessConfig_3", "ebg-aqap-banks-hsurb-dc"), (String)"", (boolean)false, (boolean)true)});
    }

    public List<BankLoginConfig> getBankFrontConfig() {
        List bankFrontConfig = super.getBankFrontConfig();
        List<BankLoginConfig> collect = bankFrontConfig.stream().filter(config -> !"charset".equals(config.getKey().getBankConfigId())).collect(Collectors.toList());
        BankLoginConfig charSetConfig = BankLoginConfigUtil.getMlBankLoginConfig((String)"charset", (MultiLangEnumBridge)new MultiLangEnumBridge("\u5b57\u7b26\u96c6", "HsurbDcMetaDataImpl_10", "ebg-aqap-banks-hsurb-dc"), (MultiLangEnumBridge)new MultiLangEnumBridge("", "", ""), Arrays.asList(new MultiLangEnumBridge("UTF-8", "", ""), new MultiLangEnumBridge("GBK", "", "")), Arrays.asList("UTF-8", "GBK"), (String)"UTF-8", (boolean)false, (boolean)false, (boolean)false);
        collect.add(charSetConfig);
        return collect;
    }

    public List<BankLoginConfig> getBasicConfigSupplement() {
        return Lists.newArrayList((Object[])new BankLoginConfig[]{BankLoginConfigUtil.getMlBankLoginConfig((String)HttpUri, (MultiLangEnumBridge)new MultiLangEnumBridge("\u901a\u8bafURI\u8def\u5f84", "HsurbDcMetaDataImpl_8", "ebg-aqap-banks-hsurb-dc"), (String)"/corporbankTest/httpAccess", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"signPort", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7b7e\u540d\u7aef\u53e3\u53f7", "HsurbDcMetaDataImpl_5", "ebg-aqap-banks-hsurb-dc"), (String)"8010", (boolean)false, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)"signProtocol", (MultiLangEnumBridge)new MultiLangEnumBridge("\u7b7e\u540d\u901a\u8baf\u534f\u8bae", "HsurbDcMetaDataImpl_6", "ebg-aqap-banks-hsurb-dc"), (String)"TCP", (boolean)true, (boolean)false), BankLoginConfigUtil.getMlBankLoginConfig((String)SignCharset, (MultiLangEnumBridge)new MultiLangEnumBridge("\u7b7e\u540d\u7f16\u7801\u5b57\u7b26\u96c6\u3002", "HsurbDcMetaDataImpl_7", "ebg-aqap-banks-hsurb-dc"), (String)"GBK", (boolean)true, (boolean)false)});
    }

    public List<Class<? extends IBankService>> getBizImplClasses() {
        return Lists.newArrayList((Object[])new Class[]{BalanceImpl.class, DetailImpl.class, GroupPaymentImpl.class, QryGroupPaymentImpl.class, PaymentImpl.class, QryPaymentImpl.class, PretreatmentImpl.class});
    }

    public BankPropertyConfig getPropertyConfig() {
        return new BankBusinessConfig();
    }

    public Map<String, String> getDetailUniqueRule() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(16);
        result.put("accNo", DetailUniqueTypeEnum.STRING.getType());
        result.put("transferDate", DetailUniqueTypeEnum.STRING.getType());
        result.put("hostSeqNb", DetailUniqueTypeEnum.STRING.getType());
        result.put("cadDebit", DetailUniqueTypeEnum.STRING.getType());
        result.put("cadCredit", DetailUniqueTypeEnum.STRING.getType());
        result.put("balance", DetailUniqueTypeEnum.BIGDECIMAL.getType());
        result.put("oppositeAccount", DetailUniqueTypeEnum.STRING.getType());
        result.put("oppositeAccountName", DetailUniqueTypeEnum.STRING.getType());
        return result;
    }
}

