/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.hsurb.dc.services.payment.group;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.SignUtils;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TPacker;
import kd.ebg.aqap.banks.hsurb.dc.services.utils.TParser;
import kd.ebg.aqap.business.payment.atomic.AbstractQueryPayImpl;
import kd.ebg.aqap.business.payment.atomic.IQueryPay;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.Sequence;
import kd.ebg.egf.common.utils.datetime.DateTimeUtils;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class QryGroupPaymentImpl
extends AbstractQueryPayImpl
implements IQueryPay {
    private static final EBGLogger logger = EBGLogger.getInstance().getLogger(QryGroupPaymentImpl.class);

    public int getBatchSize() {
        return 0;
    }

    public String pack(BankPayRequest bankPayRequest) {
        List paymentInfos = bankPayRequest.getPaymentInfos();
        PaymentInfo paymentInfo = (PaymentInfo)paymentInfos.get(0);
        String tr_code = "CBE016";
        String cid = RequestContextUtils.getBankParameterValue((String)"CustomerId");
        String branchId = RequestContextUtils.getBankParameterValue((String)"BranchId");
        String groupId = RequestContextUtils.getBankParameterValue((String)"groupId");
        String d = DateTimeUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String req_no = Sequence.genSequence();
        Element QLBankData = TPacker.createCommonHead(tr_code, cid, req_no, d);
        Element opReq = QLBankData.getChild("opReq");
        Element ReqParam = opReq.getChild("ReqParam");
        JDomUtils.addChild((Element)ReqParam, (String)"accountNo", (String)paymentInfo.getAccNo());
        JDomUtils.addChild((Element)ReqParam, (String)"serialNo", (String)paymentInfo.getPackageId());
        JDomUtils.addChild((Element)ReqParam, (String)"currencyType", (String)paymentInfo.getCurrency());
        LocalDateTime sst = paymentInfo.getSubmitSuccessTime();
        JDomUtils.addChild((Element)ReqParam, (String)"beginDate", (String)sst.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ReqParam, (String)"endDate", (String)sst.format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageBgnPos", (String)"1");
        JDomUtils.addChild((Element)ReqParam, (String)"turnPageShowQnt", (String)"20");
        JDomUtils.addChild((Element)ReqParam, (String)"branchId", (String)branchId);
        JDomUtils.addChild((Element)ReqParam, (String)"groupId", (String)groupId);
        String str = paymentInfo.getAccNo() + "|" + paymentInfo.getCurrency() + "|" + groupId;
        JDomUtils.addChild((Element)ReqParam, (String)"signDataStr", (String)str);
        String signData = SignUtils.sign(str);
        JDomUtils.addChild((Element)ReqParam, (String)"signData", (String)signData);
        String encoding = RequestContextUtils.getCharset();
        String xmlMsg = JDomUtils.root2StringNoIndentLineNoSeparator((Element)QLBankData, (String)encoding);
        String msg = tr_code + "|#" + xmlMsg;
        return msg;
    }

    public EBBankPayResponse parse(BankPayRequest bankPayRequest, String s) {
        List infos = bankPayRequest.getPaymentInfos();
        String encoding = RequestContextUtils.getCharset();
        String xml = TParser.parseRsp(s, encoding);
        Element QLBankData = JDomUtils.string2Root((String)xml, (String)encoding);
        Element opResult = QLBankData.getChild("opRep").getChild("opResult");
        if (opResult == null) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryGroupPaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(infos);
        }
        Element list = opResult.getChild("list");
        if (list == null) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryGroupPaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(infos);
        }
        Element row = list.getChild("row");
        if (row == null) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryGroupPaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)"", (String)"");
            return new EBBankPayResponse(infos);
        }
        String orderState = row.getChildTextTrim("orderState");
        if ("90".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryGroupPaymentImpl_1", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"QryGroupPaymentImpl_1", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        } else if ("91".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryGroupPaymentImpl_2", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"QryGroupPaymentImpl_2", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        } else if ("50".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.SUBMITED, (String)ResManager.loadKDString((String)"\u94f6\u884c\u5904\u7406\u4e2d", (String)"QryGroupPaymentImpl_3", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)orderState, (String)ResManager.loadKDString((String)"\u4e3b\u673a\u5904\u7406\u4e2d", (String)"QryGroupPaymentImpl_4", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        } else if ("99".equals(orderState)) {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u53ef\u7591", (String)"QryGroupPaymentImpl_5", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u53ef\u7591", (String)"QryGroupPaymentImpl_5", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        } else {
            EBGBusinessUtils.setPaymentState((List)infos, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryGroupPaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]), (String)orderState, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u7ed3\u679c\u672a\u77e5", (String)"QryGroupPaymentImpl_0", (String)"ebg-aqap-banks-hsurb-dc", (Object[])new Object[0]));
        }
        return new EBBankPayResponse(infos);
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return "CBE016";
    }

    public String getBizDesc() {
        return null;
    }
}

