/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment;

import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.payment.allocate.AllocPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.batchpay.BtcPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.collection.CollectPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.foreign.ForeignPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.salary.SalPaymentImpl;
import kd.ebg.aqap.banks.arcu.dc.services.payment.sbank.SbankPaymentImpl;
import kd.ebg.aqap.business.payment.atomic.BusiImplInfo;
import kd.ebg.aqap.business.payment.atomic.IPretreat;
import kd.ebg.aqap.business.payment.bank.BankPayRequest;
import kd.ebg.aqap.business.payment.bank.EBBankPayResponse;
import kd.ebg.aqap.common.framework.utils.UseConvertor;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;

public class PretreatmentImpl
implements IPretreat {
    public BusiImplInfo getBusiImplInfo(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = new BusiImplInfo();
        StringBuilder packageKey = new StringBuilder();
        packageKey.append("accNo=").append(paymentInfo.getAccNo());
        packageKey.append(";");
        packageKey.append("sameBank=").append(paymentInfo.is2SameBank());
        packageKey.append(";");
        packageKey.append("urgent=").append(paymentInfo.is2Urgent());
        packageKey.append(";");
        busiImplInfo.setPackageKey(packageKey.toString());
        String subBizType = paymentInfo.getSubBizType();
        if ("pay_for_salary".equals(subBizType)) {
            busiImplInfo.setImplName(SalPaymentImpl.class.getName());
        } else if ("pay_for_capital_allocation".equals(subBizType)) {
            if (UseConvertor.isTransUp((PaymentInfo)paymentInfo)) {
                busiImplInfo.setImplName(CollectPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(AllocPaymentImpl.class.getName());
            }
        } else if ("pay".equals(subBizType)) {
            if (UseConvertor.isSalary((PaymentInfo)paymentInfo)) {
                busiImplInfo.setImplName(BtcPaymentImpl.class.getName());
            } else if (paymentInfo.is2SameBank()) {
                busiImplInfo.setImplName(SbankPaymentImpl.class.getName());
            } else {
                busiImplInfo.setImplName(ForeignPaymentImpl.class.getName());
            }
        } else {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u5b89\u5fbd\u519c\u4fe1\u793e\u6682\u4e0d\u652f\u6301%s\u4e1a\u52a1\u3002", (String)"PretreatmentImpl_2", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), subBizType));
        }
        busiImplInfo.setPackageKey(packageKey.toString());
        return busiImplInfo;
    }

    public void appendData(PaymentInfo paymentInfo) {
        BusiImplInfo busiImplInfo = this.getBusiImplInfo(paymentInfo);
        paymentInfo.setImplClassName(busiImplInfo.getImplName());
        paymentInfo.setQueryImplClassName(busiImplInfo.getQueryImplName());
        paymentInfo.setPackageKey(busiImplInfo.getPackageKey());
    }

    public EBBankPayResponse doBiz(BankPayRequest bankPayRequest) {
        return null;
    }

    public String getDeveloper() {
        return null;
    }

    public String getBizCode() {
        return null;
    }

    public String getBizDesc() {
        return null;
    }

    public boolean match(PaymentInfo paymentInfo) {
        return true;
    }
}

