/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.arcu.dc.services.payment.common;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.arcu.dc.services.payment.common.CommonParser;
import kd.ebg.aqap.banks.arcu.dc.services.utils.ARCU_DC_Parser;
import kd.ebg.aqap.business.payment.utils.EBGBusinessUtils;
import kd.ebg.aqap.common.entity.biz.status.PaymentState;
import kd.ebg.aqap.common.model.PaymentInfo;
import kd.ebg.egf.common.context.RequestContextUtils;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.framework.bank.info.BankResponse;
import kd.ebg.egf.common.utils.xml.JDomUtils;
import org.jdom2.Element;

public class CommonQueryPayParser {
    public static void parserPaymentState(PaymentInfo[] paymentInfos, String rspStr) {
        Element root = JDomUtils.string2Root((String)rspStr, (String)RequestContextUtils.getCharset());
        BankResponse bankResponse = ARCU_DC_Parser.parserCommonHeader(root);
        if (null == bankResponse.getResponseCode() || !"000000".equals(bankResponse.getResponseCode())) {
            throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u7ed3\u679c\u51fa\u9519\u3002\u94f6\u884c\u8fd4\u56de:%s\u3002", (String)"CommonQueryPayParser_5", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), bankResponse.getResponseCode()));
        }
        Element body = JDomUtils.getChildElement((Element)root, (String)"Body");
        Element list = JDomUtils.getChildElement((Element)body, (String)"List");
        List mapsList = list.getChildren("Map");
        if (mapsList.size() <= 0) {
            throw EBExceiptionUtil.serviceException((String)ResManager.loadKDString((String)"\u89e3\u6790\u94f6\u884c\u660e\u7ec6\u4e3a\u7a7a\u3002", (String)"CommonQueryPayParser_1", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]));
        }
        Map<String, PaymentInfo> paymentUniquece = CommonQueryPayParser.getPaymentUniqueFlag(paymentInfos);
        for (int i = 0; i < mapsList.size(); ++i) {
            String payerAcNo = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"PayerAcNo");
            String payeeAcNo = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"PayeeAcNo");
            String amout = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"Amount");
            String payeeAcName = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"PayeeAcName");
            String seqenceID = payerAcNo + payeeAcNo + amout + payeeAcName;
            String status = JDomUtils.getChildText((Element)((Element)mapsList.get(i)), (String)"Status");
            if (!paymentUniquece.containsKey(seqenceID)) continue;
            PaymentInfo payInfo = paymentUniquece.get(seqenceID);
            if (CommonQueryPayParser.isSuccess(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.SUCCESS, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u6210\u529f", (String)"CommonQueryPayParser_2", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)status, (String)CommonParser.getBankMsg(status));
                continue;
            }
            if (CommonQueryPayParser.isFailed(status)) {
                EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.FAIL, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u5931\u8d25", (String)"CommonQueryPayParser_3", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)status, (String)CommonParser.getBankMsg(status));
                continue;
            }
            EBGBusinessUtils.setPaymentState((PaymentInfo)payInfo, (PaymentState)PaymentState.UNKNOWN, (String)ResManager.loadKDString((String)"\u4ea4\u6613\u72b6\u6001\u672a\u77e5", (String)"CommonQueryPayParser_4", (String)"ebg-aqap-banks-arcu-dc", (Object[])new Object[0]), (String)status, (String)CommonParser.getBankMsg(status));
        }
    }

    private static boolean isSuccess(String statusCode) {
        return "0".equals(statusCode);
    }

    private static boolean isFailed(String statusCode) {
        return "1".equals(statusCode) || "2".equals(statusCode) || "7".equals(statusCode);
    }

    private static Map<String, PaymentInfo> getPaymentUniqueFlag(PaymentInfo[] paymentInfos) {
        ConcurrentHashMap<String, PaymentInfo> paymentUniquesMap = new ConcurrentHashMap<String, PaymentInfo>();
        for (int i = 0; i < paymentInfos.length; ++i) {
            String accNo = paymentInfos[i].getAccNo();
            String incomeAccNo = paymentInfos[i].getIncomeAccNo();
            String amount = paymentInfos[i].getAmount().toString();
            String incomeAccName = paymentInfos[i].getIncomeAccName();
            paymentUniquesMap.put(accNo + incomeAccNo + amount + incomeAccName, paymentInfos[i]);
        }
        return paymentUniquesMap;
    }
}

