/*
 * Decompiled with CFR 0.152.
 */
package kd.ebg.aqap.banks.gdb.opa.service.detail;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.ebg.aqap.banks.gdb.opa.service.balance.BalanceImpl;
import kd.ebg.aqap.banks.gdb.opa.util.Packer;
import kd.ebg.aqap.banks.gdb.opa.util.Parser;
import kd.ebg.aqap.banks.gdb.opa.util.SendUtil;
import kd.ebg.aqap.business.detail.atomic.AbstractDetailImpl;
import kd.ebg.aqap.business.detail.atomic.IDetail;
import kd.ebg.aqap.business.detail.atomic.IHisDetail;
import kd.ebg.aqap.business.detail.bank.BankDetailRequest;
import kd.ebg.aqap.business.detail.bank.EBBankDetailResponse;
import kd.ebg.aqap.common.model.DetailInfo;
import kd.ebg.egf.common.exception.EBExceiptionUtil;
import kd.ebg.egf.common.log.EBGLogger;
import kd.ebg.egf.common.utils.string.StringUtils;

public class DetailImpl
extends AbstractDetailImpl
implements IDetail,
IHisDetail {
    private static EBGLogger logger = EBGLogger.getInstance().getLogger(BalanceImpl.class);
    private static String pageSize = "10";
    private static Integer startPage = 0;

    public EBBankDetailResponse doBiz(BankDetailRequest rqst) {
        try {
            String rqstStr = this.pack(rqst);
            String rspStr = SendUtil.send(this.getBizCode(), rqstStr);
            return this.parse(rqst, rspStr);
        }
        catch (Exception e) {
            throw EBExceiptionUtil.serviceException((Throwable)e);
        }
    }

    public EBBankDetailResponse detail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage(startPage);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public EBBankDetailResponse hisDetail(BankDetailRequest request) {
        ArrayList detailInfos = new ArrayList(1);
        this.setCurrentPage(startPage);
        this.setLastPage(false);
        while (!this.isLastPage()) {
            EBBankDetailResponse detailResponse = this.doBiz(request);
            detailInfos.addAll(detailResponse.getDetails());
            this.setCurrentPage(String.valueOf(Integer.parseInt(this.getCurrentPage()) + 1));
        }
        return new EBBankDetailResponse(detailInfos);
    }

    public String getDeveloper() {
        return "ht";
    }

    public String getBizCode() {
        return "acctTrxDetailQuery";
    }

    public String getBizDesc() {
        return ResManager.loadKDString((String)"\u67e5\u8be2\u4ea4\u6613\u660e\u7ec6", (String)"DetailImpl_0", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]);
    }

    public String pack(BankDetailRequest bankDetailRequest) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("Header", (Object)Packer.createHeader());
        JSONObject body = new JSONObject();
        jsonObject.put("Body", (Object)body);
        body.put("account", (Object)bankDetailRequest.getAcnt().getAccNo());
        body.put("ccyType", (Object)bankDetailRequest.getBankCurrency());
        body.put("beginDate", (Object)bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("endDate", (Object)bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")));
        body.put("pageNo", (Object)this.getCurrentPage());
        body.put("pageSize", (Object)pageSize);
        return jsonObject.toString();
    }

    public EBBankDetailResponse parse(BankDetailRequest bankDetailRequest, String s) {
        JSONObject jsonObject = JSONObject.parseObject((String)s);
        Parser.parseHeader(jsonObject.getJSONObject("Header"), this.getBizDesc());
        JSONObject body = jsonObject.getJSONObject("Body");
        String sysRetCode = body.getString("bizRetCode");
        String sysRetInfo = body.getString("bizRetInfo");
        if (!"000000".equals(sysRetCode)) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u672c\u6b21%1$s\u4e1a\u52a1\u5931\u8d25\uff0c\u5f02\u5e38\u8fd4\u56de\u7801:%2$s,\u5f02\u5e38\u4fe1\u606f\uff1a%3$s", (String)"DetailImpl_5", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), this.getBizDesc(), sysRetCode, sysRetInfo);
            logger.info(errorMsg);
            throw EBExceiptionUtil.serviceException((String)errorMsg);
        }
        String ttlCnt = body.getString("ttlCnt");
        if ("0".equalsIgnoreCase(ttlCnt)) {
            logger.info("\u8d26\u53f7{}\u65e5\u671f{}-{}\u5e01\u79cd{}\u8fd4\u56de\u4ea4\u6613\u660e\u7ec6\u6570\u91cf\u4e3a0", new Object[]{bankDetailRequest.getAcnt().getAccNo(), bankDetailRequest.getStartDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")), bankDetailRequest.getEndDate().format(DateTimeFormatter.ofPattern("yyyyMMdd")), bankDetailRequest.getBankCurrency()});
            this.setLastPage(true);
            return new EBBankDetailResponse(new ArrayList(16));
        }
        String lastPageFlag = body.getString("lastPageFlag");
        this.setLastPage("Y".equalsIgnoreCase(lastPageFlag));
        JSONArray array = body.getJSONArray("acctTrxDetailList");
        ArrayList<DetailInfo> detailInfos = new ArrayList<DetailInfo>(16);
        for (int i = 0; i < array.size(); ++i) {
            JSONObject detailJson = array.getJSONObject(i);
            String trxDate = detailJson.getString("trxDate");
            String trxTime = detailJson.getString("trxTime");
            String ccyType = detailJson.getString("ccyType");
            String ccyFlag = detailJson.getString("ccyFlag");
            String loanSign = detailJson.getString("loanSign");
            String amount = detailJson.getString("amount");
            String balance = detailJson.getString("balance");
            String absCode = detailJson.getString("absCode");
            String absCodeMsg = detailJson.getString("absCodeMsg");
            String oppoAcctNo = detailJson.getString("oppoAcctNo");
            String oppoAcctNm = detailJson.getString("oppoAcctNm");
            String oppoBkNo = detailJson.getString("oppoBkNo");
            String oppoBkNm = detailJson.getString("oppoBkNm");
            String remark = detailJson.getString("remark");
            String postscript = detailJson.getString("postscript");
            String hostDate = detailJson.getString("hostDate");
            String hostSeqNo = detailJson.getString("hostSeqNo");
            String hostTrxId = detailJson.getString("hostTrxId");
            DetailInfo detail = new DetailInfo();
            if (StringUtils.isNotEmpty((String)balance)) {
                detail.setBalance(new BigDecimal(balance));
            }
            if ("C".equalsIgnoreCase(loanSign)) {
                detail.setCreditAmount(new BigDecimal(amount));
                detail.setDebitAmount(new BigDecimal("0.00"));
            } else if ("D".equalsIgnoreCase(loanSign)) {
                detail.setDebitAmount(new BigDecimal(amount));
                detail.setCreditAmount(new BigDecimal("0.00"));
            } else {
                throw EBExceiptionUtil.serviceException((String)String.format(ResManager.loadKDString((String)"\u94f6\u884c\u8fd4\u56de\u7684loanSign[\u501f\u8d37\u6807\u5fd7]\u4e0d\u53ef\u77e5,\u671f\u671b\u503c\u662fC\u6216D.\u5f53\u524d\u8fd4\u56de\u503cloanSign=%s", (String)"DetailImpl_6", (String)"ebg-aqap-banks-gdb-opa", (Object[])new Object[0]), loanSign));
            }
            detail.setCurrency(ccyType);
            detail.setTransDate(LocalDate.parse(hostDate, DateTimeFormatter.ofPattern("yyyyMMdd")));
            String transTime = trxDate + trxTime;
            detail.setTransTime(LocalDateTime.parse(transTime, DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));
            detail.setAccNo(bankDetailRequest.getAcnt().getAccNo());
            detail.setAccName(bankDetailRequest.getAcnt().getAccName());
            detail.setBankName(bankDetailRequest.getAcnt().getBankName());
            detail.setOppAccNo(oppoAcctNo);
            detail.setOppAccName(oppoAcctNm);
            detail.setOppBankName(oppoBkNm);
            if (!StringUtils.isEmpty((String)postscript)) {
                if (!StringUtils.isEmpty((String)absCodeMsg)) {
                    detail.setExplanation(postscript + "-" + absCodeMsg);
                } else {
                    detail.setExplanation(postscript);
                }
            } else {
                detail.setExplanation(absCodeMsg);
            }
            detail.setJsonMap(detailJson.toJSONString());
            detail.setBankDetailNo(hostTrxId);
            detailInfos.add(detail);
        }
        return new EBBankDetailResponse(detailInfos);
    }
}

